#include <stdlib.h>
#include <stdio.h>
#include <crypt.h>
#include "sha256.h"

/*
#define EXBPSW_DEBUG
*/

int main( int argc, char* argv[] )
{
    FILE *f;
    int i, j;
    char output[65];
    sha256_context ctx;
    unsigned char buf[1000];
    unsigned char sha256sum[32];

    if( argc < 2 )
    {
        printf( "Usage: sha256sum filename\n" );
		exit(1);
    }
    else
    {
        if( ! ( f = fopen( argv[1], "rb" ) ) )
        {
            perror( "fopen" );
            return( 1 );
        }

        sha256_starts( &ctx );

        while( ( i = fread( buf, 1, sizeof( buf ), f ) ) > 0 )
        {
            sha256_update( &ctx, buf, i );
        }

        sha256_finish( &ctx, sha256sum );

        for( j = 0; j < 32; j++ )
        {
            printf( "%02x", sha256sum[j] );
        }

        printf( "  %s\n", argv[1] );
    }

    return( 0 );
}
