Summary: The EXT2 file system utilities and libraries.
Name: e2fsprogs
Version: 1.27
Release: 1.0.0.%{_hhl_build_id}
Source: e2fsprogs_%{version}.orig.tar.gz
Source1: e2fsprogs.tmpl
Source2: e2fsprogs-doc.tmpl
Source3: comerr-dev.tmpl
Source4: ss-dev.tmpl
Source5: uuid-dev.tmpl
Source6: e2fslibs-dev.tmpl
Patch: e2fsprogs_%{version}-2.diff.gz
License: GPL
Group: base
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-e2fsprogs
Obsoletes : hhl-%{_hhl_target_arch}-e2fsprogs
Provides: libcomerr libss libext2fs libe2p2 libuuid e2fslibs

%description
EXT2 stands for "Extended Filesystem", version 2. It's the main
filesystem type used for hard disks on Linux systems.

This package contains programs for creating, checking, and maintaining EXT2
filesystems, and the generic `fsck' wrapper.


%package -n e2fsprogs-doc
Summary: The EXT2 file system utilities and libraries.
Group: base


Obsoletes : hhl-%{_hhl_target_arch}-e2fsprogs-doc

%description -n e2fsprogs-doc
EXT2 stands for "Extended Filesystem", version 2. It's the main
filesystem type used for hard disks on Debian and other Linux systems.

This package contains programs for creating, checking, and maintaining EXT2
filesystems, and the generic `fsck' wrapper.

This package includes the documentation for e2fsprogs.


%package -n comerr-dev
Summary: The Common Error Description library - headers and static libraries.
Group: devel
Requires: libcomerr
Obsoletes : hhl-%{_hhl_target_arch}-comerr-dev

%description -n comerr-dev
libcomerr is an attempt to present a common error-handling mechanism to
manipulate the most common form of error code in a fashion that does not
have the problems identified with mechanisms commonly in use.


%package -n ss-dev
Summary: Command-line interface parsing library - headers and static libraries.
Group: devel
Requires: libss
Obsoletes : hhl-%{_hhl_target_arch}-ss-dev

%description -n ss-dev
This package includes a tool that parses a command table to generate
a simple command-line interface parser, the include files needed to
compile and use it, and the static libs.
 
It was originally inspired by the Multics SubSystem library.


%package -n uuid-dev
Summary: Universally unique id library - headers and static libraries.
Group: devel
Requires: e2fsprogs
Obsoletes : hhl-%{_hhl_target_arch}-uuid-dev

%description -n uuid-dev
libuuid generates and parses 128-bit universally unique id's (UUID's),
using a standard which is blessed by both Microsoft and DCE, and is
being proposed as an internet standard.  See the internet-draft:

               draft-leach-uuids-guids-01.txt

for more information.


%package -n e2fslibs-dev
Summary: The headers and static libraries for ext2fs-aware tools-development.
Group: devel
Requires: comerr-dev e2fsprogs
Provides: e2fs-dev e2p-dev
Obsoletes : hhl-%{_hhl_target_arch}-e2fslibs-dev

%description -n e2fslibs-dev
EXT2FS stands for "Extended Filesystem", version 2. It's the filesystem
type used for hard disks on Linux systems.

This package contains the headers and shared libraries needed to compile
ext2fs-aware programs. Only programmers that really manipulate
features specific to the ext2 filesystem will need this. Most
programmers will use the generic filesystem-independent interface
from libc.

It also contains dev files for the e2p lib used by
the e2fsprogs, but which is not yet packaged all by itself
because it lacks documentation. It may also lack some support
files, by I can't really know until someone uses it...

libe2p is for user-level e2fsprogs commands.  It's used by dumpe2fs,
chattr, and lsattr.  Functions in libe2p typically have two
characteristics (a) don't require that block device containing the
filesystem be opened directly (functions in libext2fs do), and (b)
libe2p typically contains printf statements or parse user input, and so
have more internationalization issues.


%prep
%target_check
%setup -q -n e2fsprogs-%{version}
%patch -p1


%build
%target_setup
%target_acplatvars
%target_configure --enable-elf-shlibs --enable-dynamic-e2fsck --libdir=/lib

%make BUILD_CC=gcc all | tee -a build.log


%install
%target_setup
rm -rf %{buildroot}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_exec_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/{et,e2p,uuid,ss,ext2fs}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/{et,ss}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man{1,2,3,4,5,6,7,8,9}

%target_makeinstall install-libs DESTDIR=%{buildroot}%{_hhl_cross_target_dir} | tee -a build.log

install -m 644 lib/ss/ss_err.h %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/ss/
for AFile in `find %{buildroot}%{_hhl_cross_target_dir}%{buildroot}%{_hhl_cross_target_dir} -type f` \
             `find %{buildroot}%{_hhl_cross_target_dir}%{buildroot}%{_hhl_cross_target_dir} -type l`; do
	mv -f $AFile `echo $AFile | sed -e 's|%{buildroot}%{_hhl_cross_target_dir}||'`
done
for AFile in %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man?/*.? \
	     %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*.info{,-*[0-9]}; do
	test -f $AFile && gzip -f $AFile || true;
done

# These links are wrong... fix them!
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcom_err.so
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libe2p.so
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libext2fs.so
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libss.so
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libuuid.so

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/lib
mv -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/lib{com_err,e2p,ext2fs,ss,uuid}.so* %{buildroot}%{_hhl_cross_target_dir}/lib/.

ln -s ../../lib/libcom_err.so.2 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcom_err.so
ln -s ../../lib/libe2p.so.2 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libe2p.so
ln -s ../../lib/libext2fs.so.2 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libext2fs.so
ln -s ../../lib/libss.so.2 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libss.so
ln -s ../../lib/libuuid.so.1 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libuuid.so

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/sbin
mv -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/{e2fsck,fsck,fsck.ext2,fsck.ext3,mke2fs,mkfs.ext2,badblocks,tune2fs,resize2fs,dumpe2fs} %{buildroot}%{_hhl_cross_target_dir}/sbin/

# tune2fs is a bloody hard link, we need to break it
(cd %{buildroot}%{_hhl_cross_target_dir}/sbin/ ;
 cp -a tune2fs tune2fs.new ;
 rm -f tune2fs ;
 mv tune2fs.new tune2fs ;
)

cd ..
cp -f COPYING LICENSE

# For some reason a bunch of bogus directories get created...
# We have already moved all of the files out of it...
rm -rf %{buildroot}%{_hhl_cross_target_dir}/var

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/e2fsprogs
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/e2fsprogs-doc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/comerr-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE4} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ss-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE5} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/uuid-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE6} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/e2fslibs-dev

%clean
rm -rf %{buildroot}


%files -n e2fsprogs
%defattr(-,root,root)
%{_hhl_cross_target_dir}/sbin/*
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/chattr
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/lsattr
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/*
%{_hhl_cross_target_dir}/lib/libcom_err.so*
%{_hhl_cross_target_dir}/lib/libe2p.so*
%{_hhl_cross_target_dir}/lib/libext2fs.so*
%{_hhl_cross_target_dir}/lib/libss.so*
%{_hhl_cross_target_dir}/lib/libuuid.so*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/e2fsprogs


%files -n e2fsprogs-doc
%defattr(-,root,root)
%doc README COPYING RELEASE-NOTES SHLIBS LICENSE
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/??attr*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/e2fsprogs-doc


%files -n e2fslibs-dev
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_info_dir}/libext2fs.info*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libe2p.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libext2fs.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libe2p.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libext2fs.so
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/ext2fs
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/e2p
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/e2fslibs-dev


%files -n uuid-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/uuidgen
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/uuidgen*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/*uuid*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libuuid.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libuuid.so
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/uuid
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/uuid-dev


%files -n comerr-dev
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/compile_et*
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/compile_et
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/et
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcom_err.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcom_err.so
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/com_err.3*
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/et
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/comerr-dev


%files -n ss-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/mk_cmds
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/ss
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/ss
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libss.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libss.so
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ss-dev


%changelog
* Thu Jan 30 2003 Michael Eager (eager@mvista.com)
- Add debugfs to e2fsprog package.
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Wed Feb 21 2001 Charles Duffy <source@mvista.com>
- First cut


