Summary   	: The PPP (Point-to-Point Protocol) daemon.
Name	  	: hhl-target-ppp
Version	  	: 2.4.1
Release	  	: %{_hhl_build_id}.3
Source	  	: ftp://cs.anu.edu.au/pub/software/ppp/ppp-%{version}.tar.gz
Source1	  	: ppp.tmpl
Patch		: ppp_2.4.1-4.diff.gz
Patch1		: ppp_2.4.1-makefile.diff
License 	: Other
Group	  	: base
Buildroot 	: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix	  	: %{_hhl_cross_target_dir}
%define _defaultdocdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

#
#	SRPM hhl-target-ppp
#
%description

The Point-to-Point Protocol (PPP) provides a standard way to transmit
datagrams over a serial link, as well as a standard way for the machines
at either end of the link (the "peers") to negotiate various optional
characteristics of the link.  Using PPP, a serial link can be used to
transmit Internet Protocol (IP) datagrams, allowing TCP/IP connections
between the peers.

#
#	RPM hhl-target-ppp
#

%package -n hhl-%{_hhl_target_arch}-ppp
Summary		: The PPP (Point-to-Point Protocol) daemon.
Group		: System Environment/Daemons
AutoReqProv	: no

%description -n hhl-%{_hhl_target_arch}-ppp

The Point-to-Point Protocol (PPP) provides a standard way to transmit
datagrams over a serial link, as well as a standard way for the machines
at either end of the link (the "peers") to negotiate various optional
characteristics of the link.  Using PPP, a serial link can be used to
transmit Internet Protocol (IP) datagrams, allowing TCP/IP connections
between the peers.

%prep
%target_check
%setup  -q -n ppp-%{version}
%patch0 -p1

# Apply all of the patches [why is does this have to be so complicated?!]
patch -p1 < upstream/patches/000_pppoe_kernel.diff
patch -p1 < debian/patches/001_udeb.diff
patch -p1 < debian/patches/002_chat.c.diff
patch -p1 < debian/patches/003_cbcp.diff
patch -p1 < debian/patches/004_auth.c.diff
patch -p1 < debian/patches/005_fsm.c.diff
patch -p1 < debian/patches/006_ipcp.c.diff
patch -p1 < debian/patches/007_ipcp.h.diff
patch -p1 < debian/patches/008_pathnames.h.diff
patch -p1 < debian/patches/009_SETUP.diff
patch -p1 < debian/patches/010_scripts_README.diff
patch -p1 < debian/patches/011_scripts_redialer.diff
patch -p1 < debian/patches/012_secure-card.diff
patch -p1 < debian/patches/013_scripts_ip-up.diff
patch -p1 < debian/patches/014_scripts_poff.diff
patch -p1 < debian/patches/015_scripts_pon.diff
patch -p1 < debian/patches/016_chat_manpage.diff
patch -p1 < debian/patches/017_memory_management.diff
patch -p1 < debian/patches/018_ip-up_option.diff
patch -p1 < debian/patches/019_fix_pppoe_install.diff
patch -p1 < debian/patches/020_IPPROTO_TCP_undefine.diff
patch -p1 < debian/patches/021_setipaddr.diff
patch -p1 < debian/patches/022_lockfile-fix.diff
patch -p1 < debian/patches/023_lcp-max-termintate.diff
patch -p1 < debian/patches/024_pppd.8-persist-maxfail.diff
patch -p1 < debian/patches/025_packet_count.diff

%patch1 -p1


%build
%target_setup
./configure \
--prefix=%{_hhl_target_prefix} \
--host=%{_hhl_target_config}   \
--target=%{_hhl_target_config}

make CC="%{_hhl_target_toolprefix}gcc -DDO_BSD_COMPRESS=0" \
	RANLIB=%{_hhl_target_toolprefix}ranlib \
	USE_PAM=1 \
	COPTS="-DLOG_PPP=LOG_LOCAL2"

%install
rm -rf %{buildroot}
%target_setup

make DESTDIR=%{buildroot}%{_hhl_cross_target_dir} \
	MANDIR=%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir} \
	install

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/

install -m 0644 include/net/pppio.h \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/
install -m 0644 include/net/*compress.h \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/

cd debian
install -m 0644 options options.ttyXX no_ppp_on_boot \
	%{buildroot}%{_hhl_cross_target_dir}/etc/ppp/
install -m 0755 ip-up ip-down \
	%{buildroot}%{_hhl_cross_target_dir}/etc/ppp/

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/
install -m 0755 pon plog poff \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/
install -m 0644 pon.1 \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/etc/init.d
install -m 0755 init \
	%{buildroot}%{_hhl_cross_target_dir}/etc/init.d/ppp

install -m 0600 pap-secrets \
	%{buildroot}%{_hhl_cross_target_dir}/etc/ppp/
install -m 2750 provider.peer \
	%{buildroot}%{_hhl_cross_target_dir}/etc/ppp/peers
install -m 2750 provider.chatscript \
	%{buildroot}%{_hhl_cross_target_dir}/etc/chatscripts

cd ..
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/etc/pam.d
install -m 0644 pppd/ppp.pam \
	%{buildroot}%{_hhl_cross_target_dir}/etc/pam.d/ppp

gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*

ln -s pon.1.gz poff.1.gz
ln -s pon.1.gz plog.1.gz

cp README LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ppp

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-ppp
%defattr(-,root,root)
%attr(2750,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/chatscripts
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/ppp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/pam.d/ppp
%attr(750,root,root) %config %dir %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/chap-secrets
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/ip-down
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/ip-up
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/no_ppp_on_boot
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/options
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/options.ttyXX
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/pap-secrets
%attr(2750,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ppp/peers
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/plog
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/poff
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/pon
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/chat
%attr(4754,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/pppd
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/pppdump
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/pppstats
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pppd
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/*.h
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ppp
%doc LICENSE

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Tue Jan 16 2000 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file

