Summary: The GNU compression utility.
Name: hhl-target-gzip
Version: 1.2.4
Release: %{_hhl_build_id}.2
Source: gzip-%{version}.tar.gz
Source1: gzip.tmpl
Patch: gzip_%{version}-33.1.diff
License: GPL
Group: base
%define pkgname hhl-%{_hhl_target_arch}-gzip
Buildroot: %{_tmppath}/%{pkgname}-%{_hhl_target_arch}-root
%define targetroot %{_hhl_cross_target_dir}
Prefix: %{targetroot}

%define _bindir		%{targetroot}%{_hhl_target_bin_dir}
%define _mandir		%{targetroot}%{_hhl_target_man_dir}
%define _docdir		%{targetroot}%{_hhl_target_doc_dir}
%define _infodir	%{targetroot}%{_hhl_target_info_dir}

%description
This is the standard GNU file compression utility, which is also the default
compression tool for Debian.  It typically operates on files with names
ending in '.gz'.

This package can also decompress '.Z' files created with 'compress'.

# gzip
%package -n hhl-%{_hhl_target_arch}-gzip
Summary: The GNU compression utility.
Group: base
AutoReqProv: no

%description -n %{pkgname}
This is the standard GNU file compression utility, which is also the default
compression tool for Debian.  It typically operates on files with names
ending in '.gz'.

This package can also decompress '.Z' files created with 'compress'.

%prep
%target_check
%setup -q -n gzip-%{version}.orig
%patch -p1

%build
%target_setup
# cheap hack since the configure script is broken!
mv configure.in configure.bak
%target_configure  --bindir=/bin
(cd .. ; mv configure.bak configure.in)

%make
%make gzip.info

%install
rm -rf %{buildroot}
%target_setup

for d in %{targetroot}/bin %{_bindir} %{_mandir}/man1 %{_infodir} ; do
    install -d %{buildroot}/$d 
done

%target_makeinstall \
	bindir=%{buildroot}%{targetroot}/bin \
	mandir=%{buildroot}%{_mandir}/man1
(cd %{buildroot}%{targetroot}/bin && ln gzip uncompress)
ln -sf ../../bin/gzip %{buildroot}%{_bindir}/gzip
ln -sf ../../bin/gunzip %{buildroot}%{_bindir}/gunzip

for i in  zcmp zegrep zforce zless znew gzexe zdiff zfgrep zgrep zmore ; do
    mv %{buildroot}%{targetroot}/bin/$i %{buildroot}%{_bindir}/$i
done

gzip -9f %{buildroot}%{_infodir}/gzip.info*
gzip -9f %{buildroot}%{_mandir}/man*/*

cat > %{buildroot}/%{_bindir}/zless <<EOF
#!/bin/sh
/bin/zcat "\$@" | /usr/bin/less
EOF
chmod 755 %{buildroot}%{_bindir}/zless
cd ..
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gzip

%clean
rm -rf %{buildroot}

%files -n %{pkgname}
%defattr(-,root,root)
%{targetroot}/bin/gunzip
%{targetroot}/bin/gzip
%{targetroot}/bin/uncompress
%{targetroot}/bin/zcat
%{_bindir}/gzexe
%{_bindir}/zcmp
%{_bindir}/zdiff
%{_bindir}/zegrep
%{_bindir}/zfgrep
%{_bindir}/zforce
%{_bindir}/zgrep
%{_bindir}/zless
%{_bindir}/zmore
%{_bindir}/znew
%{_infodir}/gzip.info.gz
%{_mandir}/man*/*

%doc README TODO LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gzip

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Mon Feb 12 2001 Matthew McLean <source@mvista.com>
- First cut
