Summary: The GNU C Library
Name: hhl-target-glibc
Version: 2.2.3
Release: %{_hhl_build_id}.21
# GNU Blessed Source -- Part of the glibc release
Source0: ftp://ftp.gnu.org/gnu/glibc/glibc-2.2.3.tar.gz
Source1: ftp://ftp.gnu.org/gnu/glibc/glibc-linuxthreads-2.2.3.tar.gz
# We don't actually support the following items.. but they are included
# for completeness
Source2: ftp://ftp.gnu.org/gnu/glibc/nss_db-2.2.tar.gz
Source3: ftp://ftp.gnu.org/gnu/glibc/nss_lwres-0.92.tar.gz

Source10: ftp://elsie.nci.nih.gov/pub/tzcode2001c.tar.gz

# HHL Configuration Files
Source20: nsswitch.conf
Source21: host.conf
Source22: hhl-libopt-build-libc
Source23: hhl-libopt-build-libm
Source25: glibc.tmpl
Source26: glibc-dev.tmpl
Source27: glibc-doc.tmpl
Source28: glibc-i18ndata.tmpl
Source29: glibc-libopt.tmpl
Source30: glibc-locales.tmpl
Source31: glibc-nscd.tmpl
Source32: glibc-pic.tmpl
Source33: glibc-prof.tmpl

# GNU Blessed Patches -- Part of the glibc release
Patch0: ftp://ftp.gnu.org/gnu/glibc/glibc-2.2.3-nss.diff

# Debian Master Patch
Patch10: glibc_2.2.3-9.diff.gz
# --- Patch contains the following: ---
# db1-addon-enabler.dpatch - old do not apply
# fhs-linux-paths.dpatch
# glibc22-disable-static.dpatch
# glibc22-eo_EO.dpatch
# glibc22-fts.dpatch 
# glibc22-getaddrinfo.dpatch - causes a segfault on ip->name translation
# glibc22-hppa.dpatch - N/A to us (no HP PA targets)
# glibc22-locales.dpatch
# glibc22-m68k-compat.dpatch - N/A to us (no m68k targets)
# glibc22-m68k-fpic.dpatch   - N/A to us (no m68k targets)
# glibc22-mips.dpatch
# glibc22-nss-upgrade.dpatch
# glibcbug.dpatch
# glibc-cvs.dpatch -- CVS experimental, do not apply
# hurd-ldflags.dpatch -- hurd - do not apply
# hurd-siocs.dpatch -- hurd - do not apply
# ldd.dpatch
# manual-texinfo4.dpatch
# pthread_create-manpage.dpatch
# sparc64-fixups.dpatch -- N/A (no current Sparc64 target)
# string2-pointer-arith.dpatch
# template.dpatch -- N/A - just a template
# --- Also contains: ---
# locales - /etc/* /usr/sbin/*
# manpages - /usr/man/man*/*
# nscd - /etc/init.d/*
# 

# MontaVista Patches
Patch20: hhl-glibc-doc-cvs.patch
Patch21: hhl-glibc-localedata-cvs.patch
Patch22: glibc-2.2.4-glob.patch
Patch23: glibc-2.2.3-malloc.patch
Patch24: glibc-2.2.4-pthread_create.patch
Patch25: hhl-glibc-rpc-cross.patch
Patch26: hhl-powerpc-fpu.patch
Patch27: hhl-powerpc-altivec.patch
Patch28: hhl-405-atomicity.patch
Patch29: hhl-mips-siginfo.patch
Patch30: hhl-glibc-2.2.3-sh-config.patch
Patch31: hhl-glibc-2.2.3-sh.patch
Patch32: hhl-mips-abi.patch
Patch33: hhl-glibc-save-lds.patch
Patch34: hhl-glibc-rpc-cpp.patch
Patch35: glibc-2.2.3-arm_sa_be.patch
Patch37: hhl-glibc-stdio.texi.patch
Patch38: hhl-glibc-mips-atomic-op.patch
Patch40: hhl-glibc-mips-regsets.patch

License: LGPL/BSD
Group: devel
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir          %{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}
BuildRequires: hhl-%{_hhl_target_arch}-kernel-headers
BuildRequires: hhl-cross-%{_hhl_target_arch}-libopt
AutoReqProv: no

%description
The GNU C Library including standard libraries used by nearly all
programs on the system, documentation, header files, etc.

# glibc
%package -n hhl-%{_hhl_target_arch}-glibc
Summary: GNU C Library: Shared libraries and Timezone data
Group: base
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc
Contains the standard libraries that are used by nearly all programs on
the system. This package includes shared versions of the standard C library
and the standard math library, as well as many others.
Timezone data is also included.

# glibc-dev
%package -n hhl-%{_hhl_target_arch}-glibc-dev
Summary: GNU C Library: Development Libraries and Header Files.
Group: devel
Requires: hhl-%{_hhl_target_arch}-kernel-headers, hhl-%{_hhl_target_arch}-glibc = %{version}
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-dev
Contains the symlinks, headers, and object files needed to compile
and link programs which use the standard C library. 

# glibc-prof
%package -n hhl-%{_hhl_target_arch}-glibc-prof
Summary: GNU C Library: Profiling Libraries.
Group: devel
Requires: hhl-%{_hhl_target_arch}-glibc = %{version}
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-prof
Static libraries compiled with profiling info (-pg) suitable for use
with gprof.  

# glibc-pic
%package -n hhl-%{_hhl_target_arch}-glibc-pic
Summary: GNU C Library: PIC archive library
Group: devel
Requires: hhl-%{_hhl_target_arch}-glibc = %{version}
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-pic
Contains an archive library (ar file) composed of individual shared objects.
This is used for creating a library which is a smaller subset of the
standard libc shared library.

# glibc-libopt
%package -n hhl-%{_hhl_target_arch}-glibc-libopt
Summary: GNU C Library: Library Optimizer information
Group: devel
Requires: hhl-%{_hhl_target_arch}-glibc = %{version}
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-libopt
Contains information for the Library Optimizer Tool.
This is used for creating libraries which are a smaller subset of the
standard shared libraries.

# glibc-locales
%package -n hhl-%{_hhl_target_arch}-glibc-locales
Summary: GNU C Library: National Language (locale) data [support]
Group: admin
Requires: hhl-%{_hhl_target_arch}-glibc-i18ndata = %{version}
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-locales
Machine-readable data files, shared objects and programs used by the
C library for localization (l10n) and internationalization
(i18n) support.

This package contains the libc.mo i18n files, plus tools to generate
locale definitions from the i18ndata package. It allows you to customize
which definitions actually get generated.

# glibc-i18ndata
%package -n hhl-%{_hhl_target_arch}-glibc-i18ndata
Summary: GNU C Library: National Language (locale) data [source]
Group: admin
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-i18ndata
Machine-readable data files used by the C library
for localization and internationalization support.

This package contains uncompiled source data for locales. To compile
locale definitions, you must have the `locales' package as well.

# glibc-nscd
%package -n hhl-%{_hhl_target_arch}-glibc-nscd
Summary: GNU C Library: Name Service Cache Daemon
Group: admin
Requires: hhl-%{_hhl_target_arch}-glibc = %{version}
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-nscd
A daemon which handles passwd and group lookups
for running programs and caches the results for the next
query. You should install this package only if you use
slow Services like LDAP, NIS or NIS+.

# glibc-doc
%package -n hhl-%{_hhl_target_arch}-glibc-doc
Summary: GNU C Library: Documentation
Group: doc
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-glibc-doc
Contains The GNU C Library Reference manual in info format as well as man
pages for libpthread functions. Also included is the complete GNU C Library
ChangeLog.

%prep
%target_check
# First thing, untar/patch to glibc2.2.3 release level
%setup -n glibc-%{version} -q -a 1
# Use the following line to activate the "nss add-ons"
#setup -n glibc-%{version} -q -a 1 -a 2 -a 3
%patch0 -p0

# Apply the master Debian Patch
%patch10 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

# glibc-cvs
# db1-addon-enabled
sh debian/patches/manual-texinfo4.dpatch -patch .
sh debian/patches/ldd.dpatch -patch .
sh debian/patches/glibcbug.dpatch -patch .
# hurd-ldflags
sh debian/patches/fhs-linux-paths.dpatch -patch .
sh debian/patches/pthread_create-manpage.dpatch -patch .
sh debian/patches/string2-pointer-arith.dpatch -patch .
sh debian/patches/glibc22-nss-upgrade.dpatch -patch .
# glibc22-getaddrinfo.dpatch
# glibc22-hppa
sh debian/patches/glibc22-eo_EO.dpatch -patch .
# glibc22-m68k-compat
sh debian/patches/glibc22-mips.dpatch -patch .
# glibc-m68k-fpic
sh debian/patches/glibc22-locales.dpatch -patch .
sh debian/patches/glibc22-fts.dpatch -patch .
sh debian/patches/glibc22-disable-static.dpatch -patch .

# Cross RPC patches
%patch25 -p1
%patch34 -p1

%patch26 -p1
%patch27 -E -p1

# PPC 405 Errata 77 Fix
%if "%{_hhl_target_arch}" == "ppc_405"
%patch28 -p1
%endif

# Correct MIPS siginfo_t structure to match kernel
%patch29 -p1
# Fix mips linker script problems
%patch32 -p1

# SH support
%patch30 -p1
%patch31 -p1

%patch33 -p1

# Support ARM Big Endian
%patch35 -p1

# Slight change to the stdio.texi to work with current makeinfo
%patch37 -p1

# Fix atomic ops on MIPS II and above
%patch38 -p1

# Fix size of prgregset_t on MIPS (included in CVS glibc)
%patch40 -p1

%if "%{_hhl_target_cpu}" == "ppc"
 %if "%{_hhl_target_cachesize}" == "4"
  # Remove broken memset.S for 8xx and 403
  # This file assumes an 8 word wide cache apparently!
  rm sysdeps/powerpc/memset.S
 %endif
%endif

%build
%target_setup
autoconf
# Things configure will get wrong:
#  - ac_tool_prefix=mipsel-hardhat-linux instead of mips_fp_le
#    (we override the only thing this is used for anyway)
#  - CPP=/lib/cpp instead of %{_hhl_target_toolprefix}gcc -E
#    when bootstrapping, because no <assert.h> exists for the
#    target.  No harm done, since it never invokes $(CPP) anyway.
ac_cv_prog_cc_works=no
export ac_cv_prog_cc_works
ac_cv_prog_cc_cross=yes
export ac_cv_prog_cc_cross

cat > ../build.log <<-EOF
%target_tool_configure \
	--libexecdir=%{_hhl_target_lib_dir} \
	--build=%{_hhl_host_config} \
	--enable-add-ons \
	--without-cvs \
%if "%{_hhl_target_fpu}" == "no"
	--without-fp \
%endif
%if "%{_hhl_target_altivec}" == "yes"
	--with-altivec=default
%endif

EOF

%target_tool_configure \
	--libexecdir=%{_hhl_target_lib_dir} \
	--build=%{_hhl_host_config} \
	--enable-add-ons \
	--without-cvs \
%if "%{_hhl_target_fpu}" == "no"
	--without-fp \
%endif
%if "%{_hhl_target_altivec}" == "yes"
	--with-altivec=default
%endif
	2>&1 | tee -a ../build.log

%make	2>&1 | tee -a ../build.log

%make -C ../linuxthreads/man all

#if cross compiling....
cd ..
mkdir -p LOCALOBJDIR
cd LOCALOBJDIR
cp -a ../timezone/* .
tar xvfz %{SOURCE10}
# Because the make file expects it...
cp yearistype yearistype.sh
%make 2>&1 | tee -a ../build.log
#endif cross compiling....

%install
%target_setup
rm -rf %{buildroot}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}

cd %{_objdir}
%make install_root=%{buildroot}%{_hhl_cross_target_dir} \
	install 2>&1 | tee -a ../build.log

(cd ../manual && makeinfo --html libc.texinfo)

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default

install -m 644 ../debian/manpages/*.1 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/.
install -m 644 ../debian/manpages/*.5 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/.
install -m 644 ../debian/manpages/*.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/.
# nsswitch.conf
install -m 644 %{SOURCE20} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/.
# host.conf
install -m 644 %{SOURCE21} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/.
install -m 755 ../debian/libc/etc/default/devpts %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/devpts
# Moved to the sysvinit package
#install -m 755 devpts.sh %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/.

install -m 755 ../debian/nscd/etc/init.d/nscd %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/nscd
install -m 755 ../debian/libc/usr/sbin/tzconfig %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/.

cd ..

#if cross compiling....
cd LOCALOBJDIR
( export TZBASE="africa antarctica asia australasia europe northamerica southamerica etcetera factory systemv solar87 solar88 solar89 backward"
./zic -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/right/ -L leapseconds -y yearistype $TZBASE 
./zic -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/posix/ -L /dev/null -y yearistype $TZBASE 
./zic -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/ -L /dev/null -y yearistype $TZBASE 
cp %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/America/New_York %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/posixrules
)
cd ..
#endif

# Fix up libc.so to use relative paths
cat %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc.so \
	| sed 's# /[^ ]*/lib# lib#g' \
	> %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc.so~
mv -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc.so~ \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc.so

# Install libc_pic in the correct location
cd %{_objdir}
mkdir -p           %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic

install -m 644 libc_pic.a      %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.
install -m 644 libc.map        %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic.map

install -m 644 elf/soinit.os   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/soinit.o
install -m 644 elf/sofini.os   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/sofini.o

install -m 644 elf/interp.os   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/interp.o

install -m 644 math/libm_pic.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.
install -m 644 libm.map        %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libm_pic.map

install -m 644 resolv/libresolv_pic.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.
install -m 644 libresolv.map   %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libresolv_pic.map

# Set Library Optimizer variables
%define _optdir %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo
OBJECTDIR=`/bin/pwd`

# Install Library Optimizer information (libc)
install -d -m 755 %{_optdir}/libc
install -m 755 %{SOURCE22} %{_optdir}/libc/build
install -m 644 libc.map %{_optdir}/libc/libc.map
install -m 644 libc.so.lds %{_optdir}/libc/libc.so.lds
install -m 644 csu/abi-note.o %{_optdir}/libc/abi-note.o
install -m 644 elf/soinit.os %{_optdir}/libc/soinit.o
install -m 644 elf/sofini.os %{_optdir}/libc/sofini.o
install -m 644 elf/interp.os %{_optdir}/libc/interp.o
(cd %{_optdir}/libc; umask 022; %{_hhl_target_toolprefix}ar x $OBJECTDIR/libc_pic.a)
(cd %{_optdir}/libc; umask 022; %{_hhl_target_toolprefix}libindex $OBJECTDIR/libc.so -r *.o -o *.os > index)
(umask 022; echo "/lib/libc-"%{version}".so" > %{_optdir}/libc/path)

# Install Library Optimizer information (libm)
install -d -m 755 %{_optdir}/libm
install -m 755 %{SOURCE23} %{_optdir}/libm/build
install -m 644 libm.map %{_optdir}/libm/libm.map
install -m 644 math/libm.so.lds %{_optdir}/libm/libm.so.lds
install -m 644 csu/abi-note.o %{_optdir}/libm/abi-note.o
install -m 644 elf/interp.os %{_optdir}/libm/interp.o
install -m 644 libc_nonshared.a %{_optdir}/libm/libc_nonshared.a
(cd %{_optdir}/libm; umask 022; %{_hhl_target_toolprefix}ar x $OBJECTDIR/math/libm_pic.a)
(cd %{_optdir}/libm; umask 022; %{_hhl_target_toolprefix}libindex $OBJECTDIR/math/libm.so -r *.o -o *.os > index)
(umask 022; echo "/lib/libm-"%{version}".so" > %{_optdir}/libm/path)

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale/locale.alias %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/locale.alias
ln -s ../../..%{_hhl_target_sysconf_dir}/locale.alias %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale/locale.alias
cd ..

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3
install -m 644 linuxthreads/man/*.3thr %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/.

install -m 644 nscd/nscd.conf %{buildroot}%{_hhl_cross_target_dir}/etc/nscd.conf

# RPM is on crack..  We need to "prepare" the doc files..
cp -pr linuxthreads/ChangeLog ChangeLog.linuxthreads
cp -pr linuxthreads/Changes Changes.linuxthreads
cp -pr linuxthreads/LICENSE LICENSE.linuxthreads
cp -pr linuxthreads/README README.linuxthreads
cp -pr linuxthreads/FAQ.html FAQ.threads.html
cp -pr localedata/ChangeLog ChangeLog.localedata
cp -pr localedata/README README.localedata
cp -pr COPYING LICENSE

gzip -9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
gzip -9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*

mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/{zdump,rpcinfo} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE25} > glibc.pml
install -m 644 glibc.pml %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE26} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE27} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-doc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE28} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-i18ndata
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE29} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-libopt
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE30} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-locales
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE31} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-nscd
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE32} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-pic
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE33} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-prof


# This is complicated enough we need to build file lists....
# glibc file list generation follows
echo "%defattr(-,root,root)" > glibc.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}/lib/ld-%{version}.so | sed -e s,%{buildroot},,`; do
 echo "%attr(0755,root,root) $i" >> glibc.filelist
done

for i in `ls %{buildroot}%{_hhl_cross_target_dir}/lib/lib*-%{version}.so | sed -e s,%{buildroot},, | grep -v libc-%{version}.so`; do
 echo "%attr(0644,root,root) $i" >> glibc.filelist
done

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}/lib/libc-%{version}.so" >> glibc.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libSegFault.so" >> glibc.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libpthread-0.9.so" >> glibc.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libthread_db-1.0.so" >> glibc.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}/lib/ -type l -name '*.so.*' ! -name 'libnss*_*.so.1*' | sed -e s,%{buildroot},,`; do
 echo "$i" >> glibc.filelist
done

echo "%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gconv" >> glibc.filelist
for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gconv/* | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc.filelist
done

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/getent" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/iconv" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/locale" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/localedef" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/catchsegv" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/glibcbug" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tzselect" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ldd" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rpcgen" >> glibc.filelist

# Do we need to do the following?
#set -e ; if [ -f "%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/lddlibc4" ] ; then \
# echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/lddlibc4" >> glibc.filelist
#fi
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}/sbin/ldconfig" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}/sbin/sln" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/zdump" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/rpcinfo" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/zic" >> glibc.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tzconfig" >> glibc.filelist
#echo "%attr(4755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_libexec_dir}/pt_chown" >> glibc.filelist
echo "%attr(4755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pt_chown" >> glibc.filelist

echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/catchsegv.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/getconf.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/getent.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/iconv.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/locale.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/localedef.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/rpcgen.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tzconfig.8.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/tzselect.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ldd.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/zdump.1.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/zic.8.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/ld.so.8.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/rpcinfo.8.gz" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/ldconfig.8.gz" >> glibc.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc.filelist
done
for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/zoneinfo/ ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc.filelist
done

echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/nsswitch.conf" >> glibc.filelist
echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/host.conf" >> glibc.filelist

echo "%attr(0755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/devpts" >> glibc.filelist
# Moved to the sysvinit package
#echo "%attr(0755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/devpts.sh" >> glibc.filelist

echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/rpc" >> glibc.filelist

# glibc-dev file list follows
echo "%defattr(-,root,root)" > glibc-dev.filelist

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/gencat" >> glibc-dev.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/getconf" >> glibc-dev.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/mtrace" >> glibc-dev.filelist

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/pcprofiledump" >> glibc-dev.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/xtrace" >> glibc-dev.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libmemusage.so" >> glibc-dev.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}/lib/libpcprofile.so" >> glibc-dev.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*.o | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-dev.filelist
done

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*.a | sed -e 's,%{buildroot},,;/^.*_.\.a$/d;/^.*_pic.a/d'`; do
 echo "%attr(0644,root,root) $i" >> glibc-dev.filelist
done

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc.so" >> glibc-dev.filelist
# This should handle the links..
# This group was removed..  at this point I'm assuming we DO want it.
#  */libthread_db.so|*/libdb.so) ;;

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/lib*.so | sed -e s,%{buildroot},,`; do
 case "$i" in \
 *-%{version}.so | *-0.[789].so ) ;; \
 */libSegFault.so) ;; \
 */libc.so ) ;; \
 *) echo $i >> glibc-dev.filelist;; \
 esac
done
# Unlike debian we _WANT_ our links relative!

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir} -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc-dev.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir} ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-dev.filelist
done

# glibc-prof file list follows
echo "%defattr(-,root,root)" > glibc-prof.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*_p.a | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-prof.filelist
done 

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/sprof" >> glibc-prof.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/sprof.1.gz" >> glibc-prof.filelist

# glibc-pic file list follows
echo "%defattr(-,root,root)" > glibc-pic.filelist

echo "%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic.a" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic.map" >> glibc-pic.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/soinit.o" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/sofini.o" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libc_pic/interp.o" >> glibc-pic.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libm_pic.a" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libm_pic.map" >> glibc-pic.filelist

echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libresolv_pic.a" >> glibc-pic.filelist
echo "%attr(0644,root,root) %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libresolv_pic.map" >> glibc-pic.filelist

# glibc-locales file list follows
echo "%defattr(-,root,root)" > glibc-locales.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc-locales.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-locales.filelist
done

echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}/etc/locale.alias" >> glibc-locales.filelist

# glibc-i18ndata file list follows
echo "%defattr(-,root,root)" > glibc-i18ndata.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/i18n -type d | sed -e s,%{buildroot},,`; do
 echo "%dir $i" >> glibc-i18ndata.filelist
done

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/i18n ! -type d | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) $i" >> glibc-i18ndata.filelist
done

# glibc-nscd file list follows
echo "%defattr(-,root,root)" > glibc-nscd.filelist

echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/nscd" >> glibc-nscd.filelist
echo "%attr(0755,root,root) %{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/nscd_nischeck" >> glibc-nscd.filelist
echo "%attr(0644,root,root) %config %{_hhl_cross_target_dir}/etc/nscd.conf" >> glibc-nscd.filelist
echo "%attr(0755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/nscd" >> glibc.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/nscd.conf.5.gz" >> glibc-nscd.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/nscd.8.gz" >> glibc-nscd.filelist
echo "%attr(0644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/nscd_nischeck.8.gz" >> glibc-nscd.filelist

# glibc-doc file list follows
echo "%defattr(-,root,root)" > glibc-doc.filelist

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*.info* | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) %doc $i" >> glibc-doc.filelist
done 

for i in `ls %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/* | sed -e s,%{buildroot},,`; do
 echo "%attr(0644,root,root) %doc $i" >> glibc-doc.filelist
done


%clean
rm -rf %{buildroot}

#post -n hhl-%{_hhl_target_arch}-glibc
#target_script_prefix_setup
# Register the service
#({_hhl_target_toolprefix}initdconfig --add devpts.sh) &> /dev/null \
#        || echo "Unable to enable initd service: devpts.sh"
#
# We only register services, not un-register them.

%files -n hhl-%{_hhl_target_arch}-glibc -f glibc.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc
%doc BUGS FAQ INSTALL INTERFACE NEWS NOTES PROJECTS README CONFORMANCE 
%doc COPYING COPYING.LIB hesiod/README.hesiod ChangeLog*
%doc Changes.linuxthreads LICENSE.linuxthreads README.linuxthreads
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-dev -f glibc-dev.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-dev
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-prof -f glibc-prof.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-prof
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-pic -f glibc-pic.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-pic
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-libopt
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo/libc
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo/libm
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-libopt
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-locales -f glibc-locales.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-locales
%doc ChangeLog.localedata README.localedata
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-i18ndata -f glibc-i18ndata.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-i18ndata
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-nscd -f glibc-nscd.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-nscd
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-glibc-doc -f glibc-doc.filelist
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/glibc-doc
%doc manual/libc.html manual/dir-add.info FAQ.threads.html
%doc LICENSE

%changelog
* Thu Mar  7 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix defect 1-L3ST - MIPS thread debugging
* Thu Feb 28 2002 Michael Eager <eager@mvista.com>
- Fix defect 1-KM1X -- use _hhl_target_include_dir not _includedir
* Fri Jan 18 2002 Michael Eager <eager@mvista.com>
- Change to make localdata/install-locales
* Mon Oct 29 2001 Michael Eager <eager@mvista.com>
- Intel StrongArm Big Endian patch
* Fri Sep 07 2001 Michael Eager <eager@mvista.com>
- Convert to use target_tool_configure.
* Thu Aug 16 2001 Joe Green <source@mvista.com>
- Added hhl-glibc-save-lds.patch to keep linker scripts for library optimizer.
- Installed abi-note.o and libc.so.lds for use by library optimizer.

* Mon Jul 20 2001 Mark Hatle <source@mvista.com>
- Moved to 2.2.3 release
- Restructures the sources/patches to be pulled from the Debian patch
  instead of individual patches.
- Renamed all MontaVista patches to include "hhl" in their names
- Removed the glibc-223pre1-fe_invalid.patch, glibc-mips-abi.patch,
  and glibc22-27.patch patches.  (No longer needed)

* Mon Jun 25 2001 Daniel Jacobowitz <source@mvista.com>
- Add workaround for ppc_405 atomic store issues.

* Fri May 25 2001 Daniel Jacobowitz <source@mvista.com>
- Add patch to fix mips rt_sigqueueinfo.

* Fri May 04 2001 Steve Kinneberg <source@mvista.com>
- Added TCT package description files for building.

* Sun Mar 18 2001 Joe Green <source@mvista.com>
- Added Library Optimizer information package for libc.

* Thu Feb 22 2001 Mark Hatle <source@mvista.com>
- Removed the db2 add-on stuff.  Its only for legacy and we don't have 
- any! <grin>

* Wed Jan 24 2001 Mark Hatle <source@mvista.com>
- Added missing rpc files
- Added sln
- Added /usr/lib/libthread_db.so
- Added /usr/lib/libdb.so

* Mon Jan 22 2001 Mark Hatle <fray@mvista.com>
- Initial push into repository
- Cross-compiling checks are still TODO

* Sat Dec 09 2000 Mark Hatle <fray@mvista.com>
- First cut

