/*
 * linux/include/linux/rtc_rx5c348.h
 *
 * driver for RICOH Rx5C348 RTC
 *
 */

#ifndef _LINUX_INCLUDE_LINUX_RTC_RX5C348_H_
#define _LINUX_INCLUDE_LINUX_RTC_RX5C348_H_


#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/miscdevice.h>
#include <linux/ioport.h>
#include <linux/fcntl.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <linux/proc_fs.h>
#include <linux/spinlock.h>
#include <linux/rtc.h>
#include <linux/time.h>
#include <asm/time.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <asm/system.h>


/* register offsets */
#define	RTC_RX5C348_SEC_REG	0x0
#define	RTC_RX5C348_MIN_REG	0x1
#define	RTC_RX5C348_HOUR_REG	0x2
#define	RTC_RX5C348_WDAY_REG	0x3
#define	RTC_RX5C348_MDAY_REG	0x4
#define	RTC_RX5C348_MONTH_REG	0x5
#define	RTC_RX5C348_YEAR_REG	0x6
#define	RTC_RX5C348_REVISE_REG	0x7
#define	RTC_RX5C348_AWMIN_REG	0x8
#define	RTC_RX5C348_AWHOUR_REG	0x9
#define	RTC_RX5C348_AWWDAY_REG	0xA
#define	RTC_RX5C348_ADMIN_REG	0xB
#define	RTC_RX5C348_ADHOUR_REG	0xC
#define	RTC_RX5C348_CTRL1_REG	0xE
#define	RTC_RX5C348_CTRL2_REG	0xF


/* register field masks */
#define RTC_RX5C348_MASK_YEAR	0xff
#define RTC_RX5C348_MASK_MONTH	0x1f
#define RTC_RX5C348_MASK_MDAY	0x3f
#define RTC_RX5C348_MASK_WDAY	0x07
#define RTC_RX5C348_MASK_HOUR	0x3f
#define RTC_RX5C348_MASK_MIN	0x7f    
#define RTC_RX5C348_MASK_SEC	0x7f    

/* Month Register Bit Def. */
#define	RTC_RX5C348_MONTH_20	0x80

/* Control 1 Regster Bit Def. */
#define	RTC_RX5C348_CTRL1_WALE	0x80
#define	RTC_RX5C348_CTRL1_DALE	0x40
#define	RTC_RX5C348_CTRL1_24	0x20
#define	RTC_RX5C348_CTRL1_CLEN2	0x10
#define	RTC_RX5C348_CTRL1_TEST	0x08
#define	RTC_RX5C348_CTRL1_CT2	0x04
#define	RTC_RX5C348_CTRL1_CT1	0x02
#define	RTC_RX5C348_CTRL1_CT0	0x01

/* Control 2 Regster Bit Def. */
#define	RTC_RX5C348_CTRL2_VDSL		0x80
#define	RTC_RX5C348_CTRL2_VDET		0x40
#define	RTC_RX5C348_CTRL2_SCRATCH1	0x20
#define	RTC_RX5C348_CTRL2_XSTP		0x10
#define	RTC_RX5C348_CTRL2_CLEN1		0x08
#define	RTC_RX5C348_CTRL2_CTFG		0x04
#define	RTC_RX5C348_CTRL2_WAFG		0x02
#define	RTC_RX5C348_CTRL2_DAFG		0x01

#define	RTC_RX5C348_WRITE_SINGLE	0x08
#define	RTC_RX5C348_WRITE_BURST		0x00
#define	RTC_RX5C348_READ_SINGLE		0x0C
#define	RTC_RX5C348_READ_BURST		0x04

unsigned long
rtc_rx5c348_get_time( void );


int
rtc_rx5c348_set_time( unsigned long t );


void __init
rtc_rx5c348_init( void );


#endif
