/*
 *
 * BRIEF MODULE DESCRIPTION
 *	Include file for NEC Eagle board.
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author: Yoichi Yuasa
 *		yyuasa@mvista.com or source@mvista.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __ASM_NEC_EAGLE_H
#define __ASM_NEC_EAGLE_H

/*
 * Board specific address mapping
 */
#define VR4122_PCI_MEM_BASE		0x10000000
#define VR4122_PCI_MEM_SIZE		0x06000000

#define VR4122_PCI_IO_BASE		0x16000000
#define VR4122_PCI_IO_SIZE		0x02000000

#define VR4122_PCI_IO_START		0x01000000
#define VR4122_PCI_IO_END		0x01ffffff

#define VR4122_PCI_MEM_START		0x12000000
#define VR4122_PCI_MEM_END		0x15ffffff

#define VR4122_ISA_IO_BASE		KSEG1ADDR(VR4122_EXTERNAL_IO_BASE)

#define VR4122_IO_PORT_BASE		KSEG1ADDR(VR4122_PCI_IO_BASE)

/*
 * IRQ block assignment
 */
#define VR4122_CPU_IRQ_BASE     0
#define VR4122_SYSINT1_IRQ_BASE 8
#define VR4122_SYSINT2_IRQ_BASE 24
#define VR4122_GIUINTL_IRQ_BASE 40
#define VR4122_GIUINTH_IRQ_BASE 56

#define VR4122_IRQ_LAST      VR4122_IRQ_GPIO31

/*
 * Interrupt Number
 */
#define VR4122_IRQ_VRC4173		VR4122_IRQ_GPIO1
#define VR4122_IRQ_MQ200		VR4122_IRQ_GPIO4
#define VR4122_IRQ_FPGA			VR4122_IRQ_GPIO5
#define VR4122_IRQ_PCI			VR4122_IRQ_GPIO5
#define VR4122_IRQ_LANCE		VR4122_IRQ_GPIO5
#define VR4122_IRQ_SIO			VR4122_IRQ_GPIO8
#define VR4122_IRQ_DCD			VR4122_IRQ_GPIO15


/*
 * On board Devices I/O Mapping
 */
#define NEC_EAGLE_SIO1RB		KSEG1ADDR(0x0DFFFEC0)
#define NEC_EAGLE_SIO1TH		KSEG1ADDR(0x0DFFFEC0)
#define NEC_EAGLE_SIO1IE		KSEG1ADDR(0x0DFFFEC2)
#define NEC_EAGLE_SIO1IID		KSEG1ADDR(0x0DFFFEC4)
#define NEC_EAGLE_SIO1FC		KSEG1ADDR(0x0DFFFEC4)
#define NEC_EAGLE_SIO1LC		KSEG1ADDR(0x0DFFFEC6)
#define NEC_EAGLE_SIO1MC		KSEG1ADDR(0x0DFFFEC8)
#define NEC_EAGLE_SIO1LS		KSEG1ADDR(0x0DFFFECA)
#define NEC_EAGLE_SIO1MS		KSEG1ADDR(0x0DFFFECC)
#define NEC_EAGLE_SIO1SC		KSEG1ADDR(0x0DFFFECE)

#define NEC_EAGLE_SIO2TH		KSEG1ADDR(0x0DFFFED0)
#define NEC_EAGLE_SIO2IE		KSEG1ADDR(0x0DFFFED2)
#define NEC_EAGLE_SIO2IID		KSEG1ADDR(0x0DFFFED4)
#define NEC_EAGLE_SIO2FC		KSEG1ADDR(0x0DFFFED4)
#define NEC_EAGLE_SIO2LC		KSEG1ADDR(0x0DFFFED6)
#define NEC_EAGLE_SIO2MC		KSEG1ADDR(0x0DFFFED8)
#define NEC_EAGLE_SIO2LS		KSEG1ADDR(0x0DFFFEDA)
#define NEC_EAGLE_SIO2MS		KSEG1ADDR(0x0DFFFEDC)
#define NEC_EAGLE_SIO2SC		KSEG1ADDR(0x0DFFFEDE)

#define NEC_EAGLE_PIOPP_DATA		KSEG1ADDR(0x0DFFFEE0)
#define NEC_EAGLE_PIOPP_STATUS		KSEG1ADDR(0x0DFFFEE2)
#define NEC_EAGLE_PIOPP_CNT		KSEG1ADDR(0x0DFFFEE4)
#define NEC_EAGLE_PIOPP_EPPADDR		KSEG1ADDR(0x0DFFFEE6)
#define NEC_EAGLE_PIOPP_EPPDATA0	KSEG1ADDR(0x0DFFFEE8)
#define NEC_EAGLE_PIOPP_EPPDATA1	KSEG1ADDR(0x0DFFFEEA)
#define NEC_EAGLE_PIOPP_EPPDATA2	KSEG1ADDR(0x0DFFFEEC)

#define NEC_EAGLE_PIOECP_DATA		KSEG1ADDR(0x0DFFFEF0)
#define NEC_EAGLE_PIOECP_CONFIG		KSEG1ADDR(0x0DFFFEF2)
#define NEC_EAGLE_PIOECP_EXTCNT		KSEG1ADDR(0x0DFFFEF4)


/*
 *  FLSHCNT Register
 */
#define NEC_EAGLE_FLSHCNT		KSEG1ADDR(0x0DFFFFA0)
#define NEC_EAGLE_FLSHCNT_FRDY		0x80
#define NEC_EAGLE_FLSHCNT_VPPE		0x40
#define NEC_EAGLE_FLSHCNT_WP2		0x01


/*
 * FLSHBANK Register
 */
#define NEC_EAGLE_FLSHBANK		KSEG1ADDR(0x0DFFFFA4)
#define NEC_EAGLE_FLSHBANK_S_BANK2	0x40
#define NEC_EAGLE_FLSHBANK_S_BANK1	0x20
#define NEC_EAGLE_FLSHBANK_BNKQ4	0x10
#define NEC_EAGLE_FLSHBANK_BNKQ3	0x08
#define NEC_EAGLE_FLSHBANK_BNKQ2	0x04
#define NEC_EAGLE_FLSHBANK_BNKQ1	0x02
#define NEC_EAGLE_FLSHBANK_BNKQ0	0x01


/*
 * SWITCH Setting Register
 */
#define NEC_EAGLE_SWTCHSET		KSEG1ADDR(0x0DFFFFA8)
#define NEC_EAGLE_SWTCHSET_DP2SW4	0x80
#define NEC_EAGLE_SWTCHSET_DP2SW3	0x40
#define NEC_EAGLE_SWTCHSET_DP2SW2	0x20
#define NEC_EAGLE_SWTCHSET_DP2SW1	0x10
#define NEC_EAGLE_SWTCHSET_DP1SW4	0x08
#define NEC_EAGLE_SWTCHSET_DP1SW3	0x04
#define NEC_EAGLE_SWTCHSET_DP1SW2	0x02
#define NEC_EAGLE_SWTCHSET_DP1SW1	0x01


/*
 * PPT Parallel Port Device Controller
 */
#define NEC_EAGLE_PPT_WRITE_DATA	KSEG1ADDR(0x0DFFFFB0)
#define NEC_EAGLE_PPT_READ_DATA		KSEG1ADDR(0x0DFFFFB2)
#define NEC_EAGLE_PPT_CNT		KSEG1ADDR(0x0DFFFFB4)
#define NEC_EAGLE_PPT_CNT2		KSEG1ADDR(0x0DFFFFB4)

/* Control Register */
#define NEC_EAGLE_PPT_INTMSK		0x20
#define NEC_EAGLE_PPT_PARIINT		0x10
#define NEC_EAGLE_PPT_SELECTIN		0x08
#define NEC_EAGLE_PPT_INIT		0x04
#define NEC_EAGLE_PPT_AUTOFD		0x02
#define NEC_EAGLE_PPT_STROBE		0x01

/* Control Rgister 2 */
#define NEC_EAGLE_PPT_PAREN		0x80
#define NEC_EAGLE_PPT_AUTOEN		0x20
#define NEC_EAGLE_PPT_BUSY		0x10
#define NEC_EAGLE_PPT_ACK		0x08
#define NEC_EAGLE_PPT_PE		0x04
#define NEC_EAGLE_PPT_SELECT		0x02
#define NEC_EAGLE_PPT_FAULT		0x01


/*
 * LEDWR Register
 */
#define NEC_EAGLE_LEDWR1		KSEG1ADDR(0x0DFFFFC0)
#define NEC_EAGLE_LEDWR2		KSEG1ADDR(0x0DFFFFC4)


/*
 * SDBINT Register
 */
#define NEC_EAGLE_SDBINT		KSEG1ADDR(0x0DFFFFD0)
#define NEC_EAGLE_SDBINT_PARINT		0x20
#define NEC_EAGLE_SDBINT_SIO2INT	0x10
#define NEC_EAGLE_SDBINT_SIO1INT	0x08
#define NEC_EAGLE_SDBINT_ENUM		0x04
#define NEC_EAGLE_SDBINT_DEG		0x02


/*
 * SDB INTMSK Register
 */
#define NEC_EAGLE_SDBINTMASK		KSEG1ADDR(0x0DFFFFD4)
#define NEC_EAGLE_SDBINTMASK_MSKPAR	0x20
#define NEC_EAGLE_SDBINTMASK_MSKSIO2	0x10
#define NEC_EAGLE_SDBINTMASK_MSKSIO1	0x08
#define NEC_EAGLE_SDBINTMASK_MSKENUM	0x04
#define NEC_EAGLE_SDBINTMASK_MSKDEG	0x02


/*
 * RSTREG Register
 */ 
#define NEC_EAGLE_RSTREG		KSEG1ADDR(0x0DFFFFD8)
#define NEC_EAGLE_RST_RSTSW		0x02
#define NEC_EAGLE_RST_LEDOFF		0x01


/*
 * PCI INT Rgister
 */
#define NEC_EAGLE_PCIINTREG		KSEG1ADDR(0x0DFFFFDC)
#define NEC_EAGLE_PCIINT_LANINT		0x10
#define NEC_EAGLE_PCIINT_CP_INTD	0x08
#define NEC_EAGLE_PCIINT_CP_INTC	0x04
#define NEC_EAGLE_PCIINT_CP_INTB	0x02
#define NEC_EAGLE_PCIINT_CP_INTA	0x01


/*
 * PCI INT Mask Register
 */
#define NEC_EAGLE_PCIINTMSKREG		KSEG1ADDR(0x0DFFFFE0)
#define NEC_EAGLE_PCIINTMSK_MSKLANINT	0x10
#define NEC_EAGLE_PCIINTMSK_MSKCP_INTD	0x08
#define NEC_EAGLE_PCIINTMSK_MSKCP_INTC	0x04
#define NEC_EAGLE_PCIINTMSK_MSKCP_INTB	0x02
#define NEC_EAGLE_PCIINTMSK_MSKCP_INTA	0x01


/*
 * CLK Division Register
 */
#define NEC_EAGLE_CLKDIV		KSEG1ADDR(0x0DFFFFE4)
#define NEC_EAGLE_CLKDIV_PCIDIV1	0x10
#define NEC_EAGLE_CLKDIV_PCIDIV0	0x08
#define NEC_EAGLE_CLKDIV_VTDIV2		0x04
#define NEC_EAGLE_CLKDIV_VTDIV1		0x02
#define NEC_EAGLE_CLKDIV_VTDIV0		0x01


/*
 * Source Revision Register
 */
#define NEC_EAGLE_REVISION		KSEG1ADDR(0x0DFFFFE8)

#endif /* __ASM_NEC_EAGLE_H */
