#ifndef BASIL_S1
#define BASIL_S1

#define FOR_PHASE2

/*
 * linux/include/asm-mips/tx4925/basil_s1/basil_s1.h
 *
 * Basil-S1 defs
 *
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef CONFIG_PCI
#include <asm/tx4925/tx4925_pci.h>
#endif

#define	TX4925_PCIMEM		0x10000000
#define	TX4925_PCIMEM_SIZE	0x01000000
#define	TX4925_PCIIO		0x11800000
#define	TX4925_PCIIO_SIZE	0x00800000

#ifdef CONFIG_PCI
#define BASIL_S1_ISA_IO_OFFSET	TX4925_PCIIO
#else
#define BASIL_S1_ISA_IO_OFFSET	0
#endif

#define	BASIL_S1_MASTER_CLOCK	18432000

#define	BASIL_S1_EBBAR2		0xb3000000

#if !defined(FOR_PHASE2)
#define BASIL_S1_IOPORT_BDSTS	(BASIL_S1_EBBAR2+0x00000000)
#define	BASIL_S1_IOPORT_BDSTS_SW1		0x0040
#define	BASIL_S1_IOPORT_BDSTS_SW2		0x0020
#define	BASIL_S1_IOPORT_BDSTS_SD_DCT		0x0008
#define	BASIL_S1_IOPORT_BDSTS_SD_WP		0x0004
#define BASIL_S1_IOPORT_DEVCTL	(BASIL_S1_EBBAR2+0x00000004)
#define	BASIL_S1_IOPORT_DEVCTL_SDCS		0x0080
#define	BASIL_S1_IOPORT_DEVCTL_RTCCS		0x0040
#define	BASIL_S1_IOPORT_DEVCTL_MODEM_RST	0x0020
#define	BASIL_S1_IOPORT_DEVCTL_BOOT_CHG		0x0010
#define	BASIL_S1_IOPORT_DEVCTL_ROMWP1		0x0008
#define	BASIL_S1_IOPORT_DEVCTL_ROMWP2		0x0004
#define	BASIL_S1_IOPORT_DEVCTL_C1RESET		0x0002
#define	BASIL_S1_IOPORT_DEVCTL_C2RESET		0x0001
#define BASIL_S1_IOPORT_DISPCNT	(BASIL_S1_EBBAR2+0x00000008)
#define	BASIL_S1_IOPORT_DISPCNT_BUZ		0x8000
#define	BASIL_S1_IOPORT_DISPCNT_LED1		0x2000
#define	BASIL_S1_IOPORT_DISPCNT_LED2		0x1000
#define	BASIL_S1_IOPORT_DISPCNT_RS		0x0800
#define	BASIL_S1_IOPORT_DISPCNT_RW		0x0400
#define	BASIL_S1_IOPORT_DISPCNT_E		0x0200
#define	BASIL_S1_IOPORT_DISPCNT_LCD_ON		0x0100
#define	BASIL_S1_IOPORT_DISPCNT_LCD7		0x0080
#define	BASIL_S1_IOPORT_DISPCNT_LCD6		0x0040
#define	BASIL_S1_IOPORT_DISPCNT_LCD5		0x0020
#define	BASIL_S1_IOPORT_DISPCNT_LCD4		0x0010
#define	BASIL_S1_IOPORT_DISPCNT_LCD3		0x0008
#define	BASIL_S1_IOPORT_DISPCNT_LCD2		0x0004
#define	BASIL_S1_IOPORT_DISPCNT_LCD1		0x0002
#define	BASIL_S1_IOPORT_DISPCNT_LCD0		0x0001
#define BASIL_S1_IOPORT_CARDSTS	(BASIL_S1_EBBAR2+0x00000010)
#define BASIL_S1_IOPORT_CARDCTL	(BASIL_S1_EBBAR2+0x00000014)
#else	/* FOR_PHASE2 */
#define BASIL_S1_IOPORT_BOOTDEV	(BASIL_S1_EBBAR2+0x00180000)
#define BASIL_S1_IOPORT_BOOTDEV_CDBOT		0x0001
#endif	/* FOR_PHASE2 */


void devctl_on(unsigned short bit);
void devctl_off(unsigned short bit);
unsigned short devctl_get(void);

/* RTC PIO access */
#define BASIL_S1_RTCCS	(1 << 25)

#if !defined(FOR_PHASE2)
#define	RTC_RX5C348_CE_ASSERT	*(volatile unsigned short *)BASIL_S1_IOPORT_DEVCTL=(BASIL_S1_IOPORT_DEVCTL_SDCS|BASIL_S1_IOPORT_DEVCTL_RTCCS|BASIL_S1_IOPORT_DEVCTL_MODEM_RST|BASIL_S1_IOPORT_DEVCTL_BOOT_CHG)

#define	RTC_RX5C348_CE_DEASSERT	*(volatile unsigned short *)BASIL_S1_IOPORT_DEVCTL=(BASIL_S1_IOPORT_DEVCTL_SDCS|BASIL_S1_IOPORT_DEVCTL_MODEM_RST|BASIL_S1_IOPORT_DEVCTL_BOOT_CHG)
#else	/* FOR_PHASE2 */
#define RTC_RX5C348_CE_ASSERT { unsigned long piodo;	\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo |= (BASIL_S1_RTCCS);				\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }
#define RTC_RX5C348_CE_DEASSERT { unsigned long piodo;	\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo &= ~(BASIL_S1_RTCCS);				\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }
#endif	/* FOR_PHASE2 */

#define BASIL_S1_DEBUG_IF	(BASIL_S1_EBBAR2+0x00100000)
#define BASIL_S1_DEBUG_IF_CLOCK 4915200

#define	BASIL_S1_RS485_RE	(1 << 12)
#define	BASIL_S1_RS485_DE	(1 << 13)
#define	BASIL_S1_RS485_5CNCT	(1 << 18)


/* Modem Board PIO access */
#define BASIL_S1_MODEM_RST	(1 << 24)
#define BASIL_S1_DTRB		(1 << 5)
#define BASIL_S1_LHKB		(1 << 2)
#define BASIL_S1_LCNT		(1 << 1)
#define BASIL_S1_FHKB		(1 << 4)
#define BASIL_S1_MDCT		(1 << 0)

#define DTRB		(TX4925_RD(TX4925_PIO_PIODO) & BASIL_S1_DTRB)
#define LHKB		(TX4925_RD(TX4925_PIO_PIODI) & BASIL_S1_LHKB)
#define LCNT		(TX4925_RD(TX4925_PIO_PIODO) & BASIL_S1_LCNT)
#define FHKB		(TX4925_RD(TX4925_PIO_PIODI) & BASIL_S1_FHKB)
#define MODEM_DCT	(TX4925_RD(TX4925_PIO_PIODI) & BASIL_S1_MDCT)

#define DTRB_DISC	{ unsigned long piodo;				\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo |= (BASIL_S1_DTRB);					\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }
#define DTRB_NORMAL	{ unsigned long piodo;				\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo &= ~(BASIL_S1_DTRB);				\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }
#define LCNT_HIGH	{ unsigned long piodo;				\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo |= (BASIL_S1_LCNT);					\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }
#define LCNT_LOW		{ unsigned long piodo;			\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo &= ~(BASIL_S1_LCNT);				\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }

/* Modem Reset */
#define MODEM_RST_RESET	{ unsigned long piodo;			\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo &= ~(BASIL_S1_MODEM_RST);			\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }
#define MODEM_RST_NORMAL { unsigned long piodo;			\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo |= (BASIL_S1_MODEM_RST);			\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }

/* ROMWP PIO access */
#define BASIL_S1_ROMWP	(1 << 26)

/* ROMWP */
#define ROM_WP_ON { unsigned long piodo;				\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo |= (BASIL_S1_ROMWP);				\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }
#define ROM_WP_OFF { unsigned long piodo;				\
			  piodo = TX4925_RD(TX4925_PIO_PIODO);		\
			  piodo &= ~(BASIL_S1_ROMWP);				\
			  TX4925_WR(TX4925_PIO_PIODO, piodo); }


/* check BOOT_CHG */
//#define IS_ROM_BOOT	(devctl_get() & BASIL_S1_IOPRT_DEVCTL_BOOT_CHG)
#define IS_ROM_BOOT	((*(vu16*)BASIL_S1_IOPORT_BOOTDEV) & BASIL_S1_IOPORT_BOOTDEV_CDBOT)
#define IS_CARD_BOOT	(!IS_ROM_BOOT)




#endif
