/*
 * drivers/net/gt642x0_mpsc.h
 *
 * UART driver for Galileo/Marvell GT-642x0 MPSC
 *
 * Original Author: Chris Zankel <chris@mvista.com>
 * Maintainer: Troy Benjegerdes <tbenjegerdes@mvista.com> and
 * 		Mark Greer <mgreer@mvista.com>
 *
 * Copyright 2001 MontaVista Software Inc.
 *
 * Based on arch/ppc/8xx_io/uart.c driver by Dan Malek
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

/*
 * should this go somewhere else eventually?? 
 * --Troy
 */
#define GT_BASE_MPSC0		0x8000
#define GT_BASE_MPSC_DIST	0x1000
#define GT_BASE_SDMA0		0x4000
#define GT_BASE_SDMA1		0x6000
#define GT_BASE_SDMA_DIST	0x2000
#define GT_BASE_BRG0		0xb200
#define GT_BASE_BRG_DIST	0x0008

#define GT_SERIAL_PORT_MULTIPLEX 0xf010

/* BRG stuff */

#define GT_BRG_BCR	0x0
#define GT_BRG_BTR	0x4
#define GT_BRG_BCR_EN	 (1<<16)
#define GT_BRG_BCR_CLKS_B_IN (0<<18)

/* UART Mode */

#define GT_SDMA_DESC_CMDSTAT_PE  (1<<0)
#define GT_SDMA_DESC_CMDSTAT_CDL (1<<1)
#define GT_SDMA_DESC_CMDSTAT_FR  (1<<3)
#define GT_SDMA_DESC_CMDSTAT_OR  (1<<6)
#define GT_SDMA_DESC_CMDSTAT_BR  (1<<9)
#define GT_SDMA_DESC_CMDSTAT_MI  (1<<10)
#define GT_SDMA_DESC_CMDSTAT_A   (1<<11)
#define GT_SDMA_DESC_CMDSTAT_AM  (1<<12)
#define GT_SDMA_DESC_CMDSTAT_CT  (1<<13)
#define GT_SDMA_DESC_CMDSTAT_C   (1<<14)
#define GT_SDMA_DESC_CMDSTAT_ES  (1<<15)
#define GT_SDMA_DESC_CMDSTAT_L   (1<<16)
#define GT_SDMA_DESC_CMDSTAT_F   (1<<17)
#define GT_SDMA_DESC_CMDSTAT_P   (1<<18)
#define GT_SDMA_DESC_CMDSTAT_EI  (1<<23)
#define GT_SDMA_DESC_CMDSTAT_OWN (1<<31)

#define GT_SDMA_DESC_CMDSTAT_STATUS_MASK 0x0000ffff

#define GT_SDMA_SDC	0x0000	/* CHANNELx_CONFIGURATION_REGISTER */
#define GT_SDMA_SDCM	0x0008	/* CHANNELx_COMMAND_REGISTER */
#define GT_SDMA_SCRDP	0x0810	/* CHANNELx_CURRENT_RX_DESCRIPTOR_POINTER */
#define GT_SDMA_SCTDP	0x0c10  /* CHANNELx_CURRENT_TX_DESCRIPTOR_POINTER */
#define GT_SDMA_SFTDP	0x0c14  /* CHANNELx_FIRST_TX_DESCRIPTOR_POINTER */

#if 0	/* XXXX */
#define GT_SDMA_CAUSE	0xb820
#define GT_SDMA_MASK 	0xb8a0
#else
#define GT_SDMA_CAUSE	0xb800
#define GT_SDMA_MASK 	0xb880
#endif

#define GT_SDMA_SDMA0_RXBUF (1<<0)
#define GT_SDMA_SDMA0_RXERR (1<<1)
#define GT_SDMA_SDMA0_TXBUF (1<<2)
#define GT_SDMA_SDMA0_TXEND (1<<3)
#define GT_SDMA_SDMA1_RXBUF (1<<8)
#define GT_SDMA_SDMA1_RXERR (1<<9)
#define GT_SDMA_SDMA1_TXBUF (1<<10)
#define GT_SDMA_SDMA1_TXEND (1<<11)

/* CHANNELx_CONFIGURATION_REGISTER */

#define GT_SDMA_SDC_RFT  (1<<0)	/* Receive FIFO Threshold 0: 8b 1: 128b */
#define GT_SDMA_SDC_SFM  (1<<1)	/* Single Frame Mode */
#define GT_SDMA_SDC_BLMR (1<<6)	/* Rx Big/Little Endian Mode */
#define GT_SDMA_SDC_BLMT (1<<7)	/* Tx Big/Little Endian Mode */
#define GT_SDMA_SDC_RIFB (1<<9)	/* Receive Interrupt on Frame Boundaries */
#define GT_SDMA_SDC_BSZ_SHIFT 12/* Burst: 0/1/2/3 = 1/2/4/8 64bit word */

/* CHANNELx_COMMAND_REGISTER */

#define GT_SDMA_SDCM_ERD (1<<7)	/* Enable Rx DMA */
#define GT_SDMA_SDCM_AR  (1<<15)	/* Abort Receive */
#define GT_SDMA_SDCM_STD (1<<16)	/* stop transmission */ 
#define GT_SDMA_SDCM_TXD (1<<23)	/* start transmission */ 
#define GT_SDMA_SDCM_AT  (1<<31)	/* transmission abort */ 



#define GT_MPSC_UART_CR_TEV	 (1<<1)	/* Enable Transmit Parity */
#define GT_MPSC_UART_CR_TPM_ODD  (0<<2)	/* Transmit Parity Odd, Low, Even, High */
#define GT_MPSC_UART_CR_TPM_LOW  (1<<2)
#define GT_MPSC_UART_CR_TPM_EVEN (2<<2)
#define GT_MPSC_UART_CR_TPM_HIGH (3<<2)
#define GT_MPSC_UART_CR_TA	 (1<<7)	/* Transmit Abort */
#define GT_MPSC_UART_CR_TCS	 (1<<9)	/* Transmit TCS Character */
#define GT_MPSC_UART_CR_REV	 (1<<17)	/* Enable Receive Parity */
#define GT_MPSC_UART_CR_RPM_ODD  (0<<18)	/* Receive Parity Odd, Low, Even, High */
#define GT_MPSC_UART_CR_RPM_LOW  (1<<18)
#define GT_MPSC_UART_CR_RPM_EVEN (2<<18)
#define GT_MPSC_UART_CR_RPM_HIGH (3<<18)
#define GT_MPSC_UART_CR_RA	 (1<<23)	/* Receive Abort */
#define GT_MPSC_UART_CR_EH	 (1<<31)	/* Enter Hunt */

#define GT_MPSC_MRR		0xb400
#define GT_MPSC_RCRR		0xb404
#define GT_MPSC_TCRR		0xb408

#define GT_MPSC_MMCRL		0x00
#define GT_MPSC_MMCRH		0x04
#define GT_MPSC_MPCR		0x08
#define GT_MPSC_CHR1		0x0c
#define GT_MPSC_CHR2		0x10
#define GT_MPSC_CHR3		0x14
#define GT_MPSC_CHR4		0x18
#define GT_MPSC_CHR5		0x1c
#define GT_MPSC_CHR6		0x20
#define GT_MPSC_CHR7		0x24
#define GT_MPSC_CHR8		0x28
#define GT_MPSC_CHR9		0x2c
#define GT_MPSC_CHR10		0x30

#define GT_MPSC_UART_UBSR	GT_MPSC_CHR1
#define GT_MPSC_UART_CR		GT_MPSC_CHR2
#define GT_MPSC_UART_MIR	GT_MPSC_CHR3
#define GT_MPSC_UART_AR		GT_MPSC_CHR9
#define GT_MPSC_UART_ESR	GT_MPSC_CHR10


/* MPSC Main Configuration Register (Low) */

#define GT_MPSC_MMCRL_MODE_HDLC		0x0
#define GT_MPSC_MMCRL_MODE_UART		0x4
#define GT_MPSC_MMCRL_MODE_BISYNC	0x5
#define GT_MPSC_MMCRL_TTX_TRANS		0x8
#define GT_MPSC_MMCRL_TRX_TRANS		0x10
#define GT_MPSC_MMCRL_ET_ENABLE		0x20
#define GT_MPSC_MMCRL_ER_ENABLE		0x40

/* MPSC Main Configuration Register (High) */

#define GT_MPSC_MMCRH_RDW_LOWLAT	(1<<22)	/* Low Latency (UART!) */
#define GT_MPSC_UART_UBSR_BRK_SHIFT	16
#define GT_MPSC_UART_UBSR_TCS_MASK	0xffffff00
#define GT_MPSC_UART_UBSR_BRK_MASK	0xff00ffff

/* MPSCx Protocol Configuration Register (MPCRx) */

#define GT_MPSC_MPCR_ISO_ISO	1<<7	/* Isochronous Mode (default: 0) */
#define GT_MPSC_MPCR_FRZ_FRZ	1<<9	/* Freeze Tx (default: 0) */
#define GT_MPSC_MPCR_UM_MULDROP	1<<10	/* Multi Dtop Mode (default: 0) */
#define GT_MPSC_MPCR_CL_SHIFT	12
#define GT_MPSC_MPCR_CL_5	0<<12
#define GT_MPSC_MPCR_CL_6	1<<12	/* (default: 1) */
#define GT_MPSC_MPCR_CL_7	2<<12
#define GT_MPSC_MPCR_CL_8	3<<12
#define GT_MPSC_MPCR_SBL_2	1<<14	/* Two stop bits (default: 0) */
#define GT_MPSC_MPCR_FLC_CTS	1<<15	/* Flow Control CTS (default: 0) */

/* MPSCx */

/* MPSCx Event Status Register (ESR) */
/* FIXME: maybe wrong!! should be int not short! */

#define GT_MPSC_ESR_CTS		0x0001
#define GT_MPSC_ESR_CD		0x0002
#define GT_MPSC_ESR_TIDLE	0x0008
#define GT_MPSC_ESR_RHS		0x0020
#define GT_MPSC_ESR_RLS		0x0080
#define GT_MPSC_ESR_RLIDL	0x0800
#define GT_MPSC_ESR_RCRx_MASK	0x0f00


/*
 * Receive and Transmit Descpritors
 */

typedef struct {
	volatile u32 bufsize:16;
	volatile u32 bytecnt:16;
	volatile u32 cmd_stat;
	volatile u32 next_desc_ptr;
	volatile u32 buffer;	/* physical address (for the MPSC) */
} gt_rx_descriptor_t;

typedef struct {
	volatile u32 bytecnt:16;
	volatile u32 shadow:16;
	volatile u32 cmd_stat;
	volatile u32 next_desc_ptr;
	volatile u32 buffer;
} gt_tx_descriptor_t;

#define SERIAL_MAGIC 0x5301
