#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <linux/config.h>
#include <linux/delay.h>
#include <linux/spinlock.h>
#include <linux/init.h>
#include <asm/tx4925/basil_s1/basil_s1.h>
#include <asm/uaccess.h>


/* Driver MajorNo Define		*/
#define LED_CHAR_MAJOR			231

#define LED_PIO_CHECK_LED3		( 1 << 20 )
#define LED_PIO_CHECK_LED2		( 1 << 19 )
#define LED_PIO_CHECK_LED1		( 1 << 3 )

#define LED_ARG_CHECK_LED3		( 1 << 2 )
#define LED_ARG_CHECK_LED2		( 1 << 1 )
#define LED_ARG_CHECK_LED1		1

/* change start:  stop debug : 2003/01/24T09:40 RSK Hirata */
/* #define LED_DEBUG                    1 */
#define LED_DEBUG                       0
/* change end  :  stop debug : 2003/01/24T09:40 RSK Hirata */

/* for spinlock */
spinlock_t basil_ledioctl_lock = SPIN_LOCK_UNLOCKED;

static int basil_led_open(struct inode * inode, struct file * file);
static int basil_led_close(struct inode * inode, struct file * file);
static int basil_led_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg);

/********************************************************/
/*	Normal LED Control Drivers			*/
/*							*/
/*							*/
/*							*/
/*							*/
/*							*/
/*       						*/
/*							*/
/********************************************************/
struct file_operations led_fopes = {
	open:		basil_led_open,
	release:	basil_led_close,
	ioctl:		basil_led_ioctl,
};

/********************************************************/
/*	Normal LED Open					*/
/********************************************************/
static int basil_led_open(struct inode * inode, struct file * file)
{
	ushort val = 0;
#if LED_DEBUG
	printk("LED: open() is called \n");
#endif
	MOD_INC_USE_COUNT;
	return val;
}

/********************************************************/
/*	Normal LED Close				*/
/********************************************************/
static int basil_led_close(struct inode * inode, struct file * file)
{
	ushort val = 0;
#if LED_DEBUG
	printk("LED: close() is called \n");
#endif
	MOD_DEC_USE_COUNT;
	return val;
}

/********************************************************/
/*	Normal LED Ioctl				*/
/********************************************************/
static int basil_led_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg)
{
	unsigned long piodo;
	unsigned long arg_wrk;

    switch( cmd ){
		case TIOCSLED1:
			if ( arg >= 2 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED1  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set LED1  arg = %d\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_PIO_PIODO);
			if ( arg == 1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED1;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED1;
			}
			TX4925_WR(TX4925_PIO_PIODO, piodo);
			return 0;

		case TIOCSLED2:
			if ( arg >= 2 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED2  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set LED2  arg = %d\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_PIO_PIODO);
			if ( arg == 1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED2;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED2;
			}
			TX4925_WR(TX4925_PIO_PIODO, piodo);
			return 0;

		case TIOCSLED3:

			if ( arg >= 2 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED3  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set LED3  arg = %d\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_PIO_PIODO);
			if ( arg == 1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED3;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED3;
			}
			TX4925_WR(TX4925_PIO_PIODO, piodo);
			return 0;

		case TIOCSLEDPTN:
			if ( arg >= 8 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED2  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set pattern is called set_pattern = 0x%x\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_PIO_PIODO);
#if LED_DEBUG
			printk("             get pio is 0x%08x\n", (int)piodo);
#endif
			if ( arg & LED_ARG_CHECK_LED3 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED3;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED3;
			}

			if ( arg & LED_ARG_CHECK_LED2 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED2;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED2;
			}

			if ( arg & LED_ARG_CHECK_LED1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED1;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED1;
			}
#if LED_DEBUG
			printk("             set pio is 0x%08x\n", (int)piodo);
#endif
			TX4925_WR(TX4925_PIO_PIODO, piodo);
			return 0;

		case TIOCGLEDSTS:
#if LED_DEBUG
			printk("LED: ioctl() get pattern is called \n");
#endif
			piodo = TX4925_RD(TX4925_PIO_PIODO);
			arg_wrk = 0;

			if ( !(piodo & LED_PIO_CHECK_LED3) ){
				arg_wrk |= LED_ARG_CHECK_LED3;
			}
			if ( !(piodo & LED_PIO_CHECK_LED2) ){
				arg_wrk |= LED_ARG_CHECK_LED2;
			}
			if ( !(piodo & LED_PIO_CHECK_LED1) ){
				arg_wrk |= LED_ARG_CHECK_LED1;
			}

			copy_to_user ( (unsigned long *)arg, &arg_wrk, sizeof(unsigned long) );
			return 0;

		default:
#if LED_DEBUG
			printk("LED: ioctl() NG commnad is called \n");
#endif
			return -EOPNOTSUPP;
	}
}

/********************************************************/
/*	Normal LED init					*/
/********************************************************/
static int __init basil_led_init_module(void){

	unsigned long piodo;

	if (register_chrdev(LED_CHAR_MAJOR, "led", &led_fopes)){
		printk(KERN_NOTICE "Can't allocate major number %d for LED Driver.\n",
		       LED_CHAR_MAJOR);
		return -EAGAIN;
	}

#if 0		/* 030523 no need LED all clear */
	piodo = TX4925_RD(TX4925_PIO_PIODO);
	piodo |= LED_PIO_CHECK_LED3 | LED_PIO_CHECK_LED2 | LED_PIO_CHECK_LED1;
	TX4925_WR(TX4925_PIO_PIODO, piodo);
#endif
	printk("Basil-S1 LED Driver\n");

	return 0;
}


void __exit basil_led_cleanup_module(void)
{
	unregister_chrdev(LED_CHAR_MAJOR, "led");
}

module_init(basil_led_init_module);
module_exit(basil_led_cleanup_module);


