
#include <linux/config.h>
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/interrupt.h>
#include <linux/tty.h>
#include <linux/tty_flip.h>
#include <linux/serial.h>
#include <linux/serialP.h>
#include <linux/major.h>
#include <linux/string.h>
#include <linux/fcntl.h>
#include <linux/ptrace.h>
#include <linux/ioport.h>
#include <linux/version.h>
#include <linux/mm.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <linux/delay.h>
#ifdef CONFIG_TX4925_SIO_CONSOLE
#include <linux/console.h>
#endif
#include <linux/tx4925_sio.h>
#include <asm/system.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/bitops.h>
#include <asm/serial.h>

#include <asm/tx4925/basil_s1/basil_s1.h>
#include <linux/basil_ppp.h>

/* Status Function Jump table */
char basil_mc_sts_idle(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_connect(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_dtmf(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_atr0(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_atr1(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_ata(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_ath0(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_ath1(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_atd(char *buf, ushort len, char evt, ushort offset);
char basil_mc_sts_init(char *buf, ushort len, char evt, ushort offset);

void basil_mc_poll(unsigned long data);

char basil_mc_timerset( char no );
char basil_mc_timerdel( char no );
char basil_dtmf_check(char code, char flg);
char basil_send_data(char *cmd, char r_flg );

char basil_check_retry( char evt );

void basil_chk_start_log( char evt );
void basil_set_log( char *buf, int size );
void basil_end_log( void );

void basil_send_upper( char *buf, char add_flg );

/*typedef char (*basil_mc_func)(char *, ushort, char, ushort);*/
basil_mc_func basil_func_tbl[] ={
	basil_mc_sts_idle,
	basil_mc_sts_dtmf,
	basil_mc_sts_connect,
	basil_mc_sts_atr0,
	basil_mc_sts_atr1,
	basil_mc_sts_ata,
	basil_mc_sts_ath0,
	basil_mc_sts_ath1,
	basil_mc_sts_atd,
	basil_mc_sts_init
};

int	basil_mc_sts = STS_IDLE;
char	basil_mc_stsopt = 0;
char	Basil_poll_flg;
char	Basil_ioctl_result;
char	Basil_ioctl_reason[30];
int	basil_ring_get;
char	Basil_open_cnt;

char	Basil_com_log_dial[LOG_BUF_MAX][LOG_BUF_MAXLEN];			/* AT command LOG for Basil -> other modem */
ulong	log_dial_lock;								/* LOG write spin_lock flag */
char	Basil_com_log_recv[LOG_BUF_MAX][LOG_BUF_MAXLEN];			/* AT command LOG for other modem -> Basil */
ulong	log_recv_lock;								/* LOG write spin_lock flag */
char	Basil_com_log_flg;							/* Loging None = 0 , Loging Dial = 1 , Loging Recv = 2 */
int	Basil_com_log_recvcnt;
int	Basil_com_log_dialcnt;

char	Basil_close_sleep_evt = 0;

DECLARE_WAIT_QUEUE_HEAD(basil_ioctl_wait);
DECLARE_WAIT_QUEUE_HEAD(basil_close_wait);

/* timer handler expire table */
struct	timer_list basil_timer[TIMER_CNT];

/* Config data table */
struct basil_ppp_conftbl basil_config_data={
	TEL_MODE,
	1,
	{
	  300,						/* EVT_TO_T1	*/
	  0,						/* EVT_TO_T2	*/
	  400,						/* EVT_TO_T3	*/
	  1600,						/* EVT_TO_T4	*/
	  0,						/* EVT_TO_T5	*/
	  600,						/* EVT_TO_T6T	*/
	  20,						/* EVT_TO_T7	*/
	}
	,{'#','0','#','*'}
};

/* Timer table */
unsigned long basil_timer_data[TIMER_CNT]=
{
	300,						/* EVT_TO_T1	*/
	0,						/* EVT_TO_T2	*/
	400,						/* EVT_TO_T3	*/
	1600,						/* EVT_TO_T4	*/
	200,						/* EVT_TO_T5	*/
	600,						/* EVT_TO_T6T	*/
	2000,						/* EVT_TO_T6F	*/
	20,						/* EVT_TO_T7	*/

	20,						/* EVT_TO_ATSEND*/
	3000,						/* EVT_TO_RETRY */
	1000,						/* EVT_TO_RING */

};

unsigned long basil_timer_flg[TIMER_CNT];

struct	timer_list basil_poll_timer;

struct basil_ppp_serchtbl basil_ppp_evt_tbl[]={
	{ { 0x0d, 0x0a, 'O', 'K', 0x0d, 0x0a }								,	 6},
	{ { 0x0d, 0x0a, 'C', 'O', 'N', 'N', 'E', 'C', 'T' }						,	 9},
	{ { 0x0d, 0x0a, 'R', 'I', 'N', 'G', 0x0d, 0x0a }						,	 8},
	{ { 0x0d, 0x0a, 'E', 'R', 'R', 'O', 'R', 0x0d, 0x0a }						,	 9},
	{ { 0x0d, 0x0a, 'B', 'U', 'S', 'Y', 0x0d, 0x0a }						,	 8},
	{ { 0x0d, 0x0a, 'N', 'O', ' ', 'A', 'N', 'S', 'W', 'E', 'R', 0x0d, 0x0a }			,	13},
	{ { 0x0d, 0x0a, 'N', 'O', ' ', 'C', 'A', 'R', 'R', 'I', 'E', 'R', 0x0d, 0x0a }			,	14},
	{ { 0x0d, 0x0a, 'N', 'O', ' ', 'D', 'I', 'A', 'L', 'T', 'O', 'N', 'E', 0x0d, 0x0a }		,	15},
	{ { 0x0d, 0x0a, 'N', 'O', ' ', 'L', 'I', 'N', 'E', 0x0d, 0x0a }					,	11},
	{ { 0x0d, 0x0a, 'L', 'I', 'N', 'E', ' ', 'I', 'N', ' ', 'U', 'S', 'E', 0x0d, 0x0a }		,	15}

};
#if 0
struct basil_ppp_serchtbl basil_ppp_evt_tbl[]={
	{"OK"		,	2},
	{"CONNECT"	,	 7},
	{"RING"		,	 4},
	{"ERROR"	,	 5},
	{"BUSY"		,	 4},
	{"NO ANSWER"	,	 9},
	{"NO CARRIER"	,	10},
	{"NO DIALTONE"	,	11},
	{"NO LINE"	,	 7},
	{"LINE IN USE"	,	11}
};
#endif
struct basil_ppp_serchtbl basil_ppp_dtmf_tbl[4]={
	{"#0#*",		4},
	{"0#*#",		4},
	{"#*#0",		4},
	{"*#0#",		4},
};

struct tty_struct	* basil_return_tty;

extern int gs_write(struct tty_struct * tty, int from_user,
                    const unsigned char *buf, int count);



void basil_mc_poll(unsigned long data)
{
	static unsigned long	fhkb_lo_jif;
	static char		fhkb_lo_flg;
	static char		fhkb_lo_1st;
	static unsigned long	lhkb_lo_jif;
	static char		lhkb_lo_flg;
	static char		lhkb_lo_1st;

	/* Re start Timer handler */
	if (Basil_poll_flg == 1 ){
		basil_poll_timer.expires = jiffies + BASIL_POLL_TIME;
		add_timer(&basil_poll_timer);
	}

	/* check FHKB pin	*/
	if( !FHKB && (fhkb_lo_flg != ON) ){										/* FHKB pin is LOW */
		if ( fhkb_lo_1st == 0 ){
			fhkb_lo_jif = jiffies;
			fhkb_lo_1st = 1;
		}
		if( jiffies >= fhkb_lo_jif + FHKB_LOW_TIM ){
			/* FHKB is LOW call event function */
			fhkb_lo_flg = ON;
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : polling - FHKB_LOW \n");
#endif
			basil_func_tbl[basil_mc_sts]((char *)NULL, (ushort)NULL, (char)EVT_FHKB_LOW, (ushort)NULL );
		}
	}else if( FHKB ){												/* FHKB pin is HIGH */
		if( fhkb_lo_flg == ON ){
			fhkb_lo_flg = OFF;
		}
		fhkb_lo_1st = 0;
	}

	/* check LHKB pin	*/
	if( !(LHKB) && (lhkb_lo_flg != ON) ){										/* LHKB pin is LOW */
		if ( lhkb_lo_1st == 0 ){
			lhkb_lo_jif = jiffies;
			lhkb_lo_1st = 1;
		}
		if( jiffies >= lhkb_lo_jif + LHKB_LOW_TIM ){
			/* LHKB is LOW call event function */
			lhkb_lo_flg = ON;
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : polling - LHKB_LOW \n");
#endif
			basil_func_tbl[basil_mc_sts]((char *)NULL, (ushort)NULL, (char)EVT_LHKB_LOW, (ushort)NULL );
		}
	}else if( LHKB ){												/* LHKB pin is HIGH */
		if( lhkb_lo_flg == ON ){
			lhkb_lo_flg = OFF;
		}
		lhkb_lo_1st = 0;
	}


}

/* for Retry send AT commnad */
char Retry_cnt;
static char Retry_buf[128];

void basil_mc_timer(unsigned long data)
{
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : basil_timer T.O. No = %d \n", (int)(data - EVT_TO_T1));
#endif
	if ( data == EVT_TO_RETRY ){
		spin_lock(basil_timer_flg);
		basil_timer_flg[data - EVT_TO_T1] = 0;
		spin_unlock(basil_timer_flg);
		if ( Retry_cnt >= AT_RETRY_MAX ){
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : send retry over\n");
#endif
			/* */
			if ( basil_mc_sts == STS_INIT ){
				/* IOCTL INIT set to RETRY_OUT */
				Basil_ioctl_result = -1;
				memcpy(Basil_ioctl_reason, "RETRY_OUT", 11);
				wake_up(&basil_ioctl_wait);
			}else{
				/* Retry Out send error message to Upper layer */
				basil_send_upper( "RETRY_OUT", 1 );
			}
			/* Set sts to IDLE */
			if ( basil_config_data.modem_mode ==FAX_MODE ){
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG retry out:LCNT set LOW(bit OFF) on IDLE\n");
#endif
				LCNT_LOW										/* PIO LCNT is Low */
			}
			if ( Basil_close_sleep_evt != 0 ){
				Basil_close_sleep_evt = 0;
				wake_up(&basil_close_wait);
			}
			Retry_cnt = 0;
			basil_mc_sts = STS_IDLE;
			basil_end_log();

		}else{
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : send retry\n");
#endif
			Retry_cnt ++;
			basil_send_data(Retry_buf, 1);
		}
	}else{
		spin_lock(basil_timer_flg);
		basil_timer_flg[data - EVT_TO_T1] = 0;
		spin_unlock(basil_timer_flg);
		basil_func_tbl[basil_mc_sts]( (char *)NULL, (ushort)NULL, (char)data, (ushort)NULL );
#if 1
		if ( Basil_close_sleep_evt == data ){
			if ( Basil_close_sleep_evt == EVT_TO_T6F ){
			}else{
				Basil_close_sleep_evt = 0;
				wake_up(&basil_close_wait);
			}
		}

#endif
	}
}
char	ioctl_init_moveflag = 0;				/* 030313 sugiyama wrote for Init timing */
char basil_mc_sts_idle(char *buf, ushort len, char evt, ushort offset)
{
  	char ret = 0;

	switch(evt){
		case EVT_CONNECT:
			if ( basil_config_data.modem_mode == MOD_MODE ){
				basil_end_log();
				basil_mc_sts = STS_CONNECT;
				ret = 1;
			}
			break;
		case EVT_RING:
#if 1			/* 030313 sugiyama wrote for Init timing */
			if ( ioctl_init_moveflag == 1 )
				break;
#endif			
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : idle-ring mode = %d\n", basil_config_data.modem_mode );
#endif
			if ( basil_config_data.modem_mode == TEL_MODE ){
				basil_ring_get ++;
				basil_mc_timerset(EVT_TO_RING);
				if ( basil_ring_get >= basil_config_data.ring_cnt ){
					basil_mc_timerdel(EVT_TO_RING);
					basil_mc_timerset(EVT_TO_ATSEND);
					break;
				}
			}
#if 1		/* 030507 sugiyama wrote */			
			if ( basil_config_data.modem_mode == FAX_MODE ){
				basil_ring_get ++;
				basil_mc_timerset(EVT_TO_RING);
			}
#endif
			if ( basil_config_data.modem_mode == MOD_MODE ){
				ret = 1;
			}
			break;
		case EVT_TO_ATSEND:
#if 1			/* 030313 sugiyama wrote for Init timing */
			if ( ioctl_init_moveflag == 1 )
				break;
#endif			
			basil_send_data("ATH1", 1);
			basil_mc_sts = STS_ATH1;
			basil_ring_get = 0;
			break;
		case EVT_ATD:
#if 1			/* 030313 sugiyama wrote for Init timing */
			if ( ioctl_init_moveflag == 1 ){
				basil_set_log( "\r\nNO CARRIER\r\n", 14 );	/* Logging flag check and set */
				basil_end_log();
				basil_send_upper( "NO CARRIER", 1 );
				ret = -1;
				break;
			}
#endif			
#if 1			/* 030506 sugiyama wrote for RING timing */
			if ( basil_ring_get > 0 ){
				basil_set_log( "\r\nNO CARRIER\r\n", 14 );	/* Logging flag check and set */
				basil_end_log();
				basil_send_upper( "NO CARRIER", 1 );
#if BASIL_PPP_DEBUG
				printk("PPP_DEBUG : idle-atd RINGING ringcout= %d", basil_ring_get );
#endif
				ret = -1;
				break;
			}
#endif
#if 1	/* 030224 sugiyama wrote MODEM mode ATD is no retry */
			if ( basil_config_data.modem_mode == MOD_MODE ){	/* MODEM MODE is not hope retry */
				break;
			}
#endif
			if ( basil_config_data.modem_mode == FAX_MODE ){
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : idle-atd LHKB = 0x%x DI:%x DO:%x\n",LHKB, TX4925_RD(TX4925_PIO_PIODI), TX4925_RD(TX4925_PIO_PIODO));
#endif
				if ( !(LHKB) ){
					basil_set_log( "\r\nLINE IN USE\r\n", 15 );	/* Logging flag check and set */
					basil_end_log();
					basil_send_upper( "LINE IN USE", 1 );
					ret = -1;
					break;
				}
				LCNT_HIGH									/* PIO LCNT is High */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG idle-atd:LCNT set HIGH(bit ON)\n");
#endif
			}
			basil_mc_timerdel(EVT_TO_RING);
			basil_mc_timerset( EVT_TO_T4 );
			basil_mc_sts = STS_ATD;
			break;
		case EVT_LHKB_LOW:
#if 1			/* 030313 sugiyama wrote for Init timing */
			if ( ioctl_init_moveflag == 1 )
				break;
#endif			
			if ( basil_config_data.modem_mode == FAX_MODE ){
#if BASIL_PPP_DEBUG
				printk("PPP_DEBUG : idle-LHKB FAX MODE send AT&R1");
#endif
				basil_chk_start_log( evt );
				basil_send_data("AT&R1", 1);
				basil_mc_sts = STS_ATR1;
				basil_ring_get = 0;
			}
			break;
		case EVT_INIT:
#if 1			/* 030506 sugiyama wrote for RING timing */
			if ( basil_ring_get != 0 ){
				ret = -EBUSY;
				break;
			}
#endif			
#if 1			/* 030313 sugiyama wrote for Init timing */
			if ( offset == 1 ){				/* send init command	*/
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : idle-INIT start initial\n");
#endif
				ioctl_init_moveflag = 1;
			}else{						/* end ioctl-init	*/
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : idle-INIT end initial\n");
#endif
				ioctl_init_moveflag = 0;
				break;
			}
#endif			
			basil_send_data(buf, 1);
			basil_mc_sts = STS_INIT;
			ret = IOCTL_INIT_OK;				/* for result check in IOCTL */
			break;

		case EVT_TO_RING:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : idle-TO ring basil_ring_get = 0\n");
#endif
			basil_end_log();
			basil_ring_get =0;
			break;

		case EVT_TO_T5:
			LCNT_LOW										/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG cont-T5:LCNT set LOW(bit OFF) on IDLE\n");
#endif
			if ( basil_mc_stsopt == EVT_DISCON )
				wake_up(&basil_ioctl_wait);
			basil_mc_sts = STS_IDLE;
			basil_mc_stsopt = 0;
			break;
#if 1	/* 030224 sugiyama wrote MODEM mode ATD is no retry */
		case EVT_ERROR:
		case EVT_BUSY:
		case EVT_NO_ANS:
		case EVT_NO_LINE:
		case EVT_NO_DIAL:
#endif
		case EVT_NO_CAR:
		case EVT_OK:
		case EVT_LINE_USE:
			ret=1;
			break;
		default:
	}
	return ret;
}


#if BASIL_PPP_DEBUG
	unsigned long jif1, jif2;		/* for get timer time */
#endif
char basil_mc_sts_connect(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;
	static char disc_test[] = { 0x7e, 0x7d, 0xdf, 0x7d, 0x23, 0xc0, 0x21, 0x7d, 0x25, 0x7d, 0x22, 0x7d, 0x20, 0x7d, 0x30, 0x55, 0x73, 0x65, 0x72, 0x20, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x33, 0x7e, '\0'};
	switch(evt){
		case EVT_NO_CAR:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : con-NO_CAR \n");
#endif
#if 1	/* for mgetty */
			if ( basil_config_data.modem_mode == FAX_MODE && (basil_mc_stsopt == EVT_FHKB_LOW || basil_mc_stsopt == EVT_DISCON) ){	/* if stsopt ==FHKB LOW already Disconnect */
				ret = 1;
				break;
			}
#else
			if ( basil_config_data.modem_mode == FAX_MODE && (basil_mc_stsopt == EVT_FHKB_LOW || basil_mc_stsopt == EVT_DISCON )){	/* if stsopt ==FHKB LOW already Disconnect */
				ret = 0 ;
				break;
			}
#endif

			DTRB_DISC										/* PIO DTRB is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG con-no_car:DTRB set DISC(bit ON) DTRB=0x%x\n", DTRB);
jif1 = jiffies;
#endif
			basil_mc_timerset(EVT_TO_T7);
			if ( basil_config_data.modem_mode == FAX_MODE )
				basil_mc_timerset(EVT_TO_T5);
			basil_mc_stsopt = EVT_NO_CAR;
#if 1	/* for mgetty */
			ret = 1;
#else
			if ( basil_config_data.modem_mode != FAX_MODE )
				ret = 1;
#endif
			break;
		case EVT_FHKB_LOW:
			if ( basil_config_data.modem_mode == FAX_MODE ){
				DTRB_DISC									/* PIO DTRB is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG con-FHKB_LO:DTRB set DISC(bit ON)DTRB=0x%x\n", DTRB);
jif1 = jiffies;
#endif
				basil_mc_timerset(EVT_TO_T7);
				basil_mc_timerset(EVT_TO_T5);
				basil_mc_stsopt = EVT_FHKB_LOW;
			}
			break;
		case EVT_TO_T5:
			LCNT_LOW										/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG cont-T5:LCNT set LOW(bit OFF) on CON\n");
#endif
/*			if ( basil_mc_stsopt == EVT_DISCON ){*/
				basil_send_upper( disc_test, 0 );
				wake_up(&basil_ioctl_wait);
/*			}*/
			basil_end_log();
			basil_mc_sts = STS_IDLE;
			basil_mc_stsopt = 0;
			break;
		case EVT_TO_T7:
			DTRB_NORMAL								/* PIO DTRB is High */
#if BASIL_PPP_DEBUG
jif2= jiffies;
printk("PPP_DEBUG con-T7-:DTRB set NORMAL(bit OFF) DTRB=0x%x, T7_jif=%d\n", DTRB, (int)(jif2-jif1) );
#endif
			if( basil_config_data.modem_mode != FAX_MODE ){
				basil_end_log();
				basil_mc_sts = STS_IDLE;
/*				if ( basil_mc_stsopt == EVT_DISCON ){*/
					basil_send_upper( disc_test, 0 );
					wake_up(&basil_ioctl_wait);
/*				}*/
				basil_mc_stsopt = 0;
			}
			break;
		case EVT_DISCON:
			DTRB_DISC										/* PIO DTRB is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG con-DISC:DTRB set DISC(bit ON) DTRB=0x%x\n", DTRB);
jif1 = jiffies;
#endif
			basil_mc_timerset(EVT_TO_T7);
			if ( basil_config_data.modem_mode == FAX_MODE )
				basil_mc_timerset(EVT_TO_T5);
			basil_mc_stsopt = EVT_DISCON;
			break;
		default:

	}
	return ret;
}

char dtmf_lcnt = 0;						/* 030507 sugiyama wrote */
char dtmf_fhkb_cnt = 0;						/* 030507 sugiyama wrote */
#define	DTMF_FHKB_CNT	2					/* 030507 sugiyama wrote */

char basil_mc_sts_dtmf(char *buf, ushort len, char evt, ushort offset)
{
	char		ret = 0;
	char		chk_ret = 0;
	static char	fax_ath_send = 0;

	switch(evt){
		case EVT_OK:
			break;
		case EVT_DATA_CHK:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : dtmf-code table check \n");
#endif
			if ( len == 1 ){
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : dtmf-code chk code = %c \n", *buf);
#endif
				chk_ret = basil_dtmf_check(*buf, 0);
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : dtmf-code chk code end");
#endif
				if ( chk_ret == -1 ){
					ret = 0;
					break;
				}
				if (chk_ret != 0 ){
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : dtmf-code Hit \n");
#endif
					basil_mc_timerset(EVT_TO_T3);
					if ( basil_config_data.modem_mode == FAX_MODE ){
						basil_mc_timerdel(EVT_TO_T6F);
						if ( fax_ath_send == 0 ){
							basil_send_data("ATH1", 0);
							basil_mc_timerset(EVT_TO_T7);
							fax_ath_send = 1;
						}
					}else{
						basil_mc_timerdel(EVT_TO_T6T);
					}
				}
			}else{
				ret = 1;
				break;
			}
			break;
		case EVT_TO_T3:
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : dtmf-TO3 \n");
#endif
			basil_dtmf_check('A', 1);			/* set NG code for reset CheckFlag */
			basil_send_data("AT&R0", 1);
			basil_mc_sts = STS_ATR0;
			fax_ath_send = 0;
			basil_mc_stsopt = EVT_TO_T3;
			break;
#if 1		/* 030507 sugiyama wrote for FHKB LOW */
		case EVT_LHKB_LOW:
			if ( (basil_config_data.modem_mode == FAX_MODE) && (dtmf_lcnt == 0) ){
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : dtmf-LHKB send ATR0\n");
#endif
				basil_mc_timerdel(EVT_TO_T6F);
				basil_mc_timerdel(EVT_TO_T7);
				basil_dtmf_check('A', 1);			/* set NG code for reset CheckFlag */
				basil_send_data("AT&R0", 1);
				basil_mc_sts = STS_ATR0;
				fax_ath_send = 0;
				basil_mc_stsopt = EVT_LHKB_LOW;
			}
			break;
		case EVT_FHKB_LOW:
			if ( (basil_config_data.modem_mode != FAX_MODE) || (dtmf_lcnt != 1) )
				break;
				
			dtmf_fhkb_cnt ++;
			if( dtmf_fhkb_cnt < DTMF_FHKB_CNT ){
#if BASIL_PPP_DEBUG
				printk("PPP_DEBUG : dtmf-FHKB cnt = %d, kick this event  \n", dtmf_fhkb_cnt);
#endif
				break;
			}
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : dtmf-FHKB_HIGH \n");
#endif
			basil_mc_timerdel(EVT_TO_T3);
#endif			
		case EVT_TO_T6T:
		case EVT_TO_T6F:
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : dtmf-TO6\n");
#endif
			basil_dtmf_check('A', 1);			/* set NG code for reset CheckFlag */
			basil_send_data("AT&R0", 1);
			basil_mc_sts = STS_ATR0;
			fax_ath_send = 0;
			basil_mc_stsopt = evt;
			break;
		case EVT_TO_T7:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : dtmf-TO7 \n");
#endif
			LCNT_HIGH							/* PIO LCNT is Hihg  */
			dtmf_lcnt = 1;							/* 030507 sugiyama wrote */
			dtmf_fhkb_cnt = 0;						/* 030507 sugiyama wrote */
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG dtmf-t7-FAX:LCNT set HIGH(bit ON)\n");
#endif
			break;
		default:
	}
	return ret;
}

char basil_mc_sts_init(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;


	switch(evt){
		case EVT_OK:
		case EVT_CONNECT:
			basil_mc_timerdel(EVT_TO_RETRY);		/* Retry timer Clear */
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : init-ok = %d \n", len);
#endif
			basil_mc_sts = STS_IDLE;
			Basil_ioctl_result = 1;
			memcpy(Basil_ioctl_reason, buf + 2 , len - 4);	/* -4 = 'CR''LF' */
			Basil_ioctl_reason[len - 4] = '\0';
			wake_up(&basil_ioctl_wait);

			break;
		case EVT_ERROR:
		case EVT_BUSY:
		case EVT_NO_ANS:
		case EVT_NO_CAR:
		case EVT_NO_DIAL:
		case EVT_NO_LINE:
		case EVT_LINE_USE:
			basil_mc_timerdel(EVT_TO_RETRY);		/* Retry timer Clear */
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : init-NG len = %d \n", len);
#endif
			basil_mc_sts = STS_IDLE;
			Basil_ioctl_result = -1;
			memcpy(Basil_ioctl_reason, buf + 2, len - 4);	/* -4 = 'CR''LF' */
			Basil_ioctl_reason[len - 4] = '\0';
			wake_up(&basil_ioctl_wait);

			break;
		default:
			break;
	}
	return ret;
}

char basil_mc_sts_ath0(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;

	switch(evt){
		case EVT_OK:
#if 1		/* 030507 sugiyama wrote for FHKB LOW */
			if ( basil_config_data.modem_mode == FAX_MODE && (basil_mc_stsopt == EVT_LHKB_LOW || basil_mc_stsopt == EVT_FHKB_LOW) ){
				basil_end_log();
				LCNT_LOW									/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atr0-ok1:LCNT set LOW(bit OFF)\n");
#endif
				if ( basil_mc_stsopt == EVT_LHKB_LOW){
					basil_chk_start_log( EVT_LHKB_LOW );
					basil_send_data("AT&R1", 1);
					basil_mc_sts = STS_ATR1;
					basil_ring_get = 0;
				}else{
					basil_mc_sts = STS_IDLE;
				}
				basil_mc_stsopt = 0;
				break;
			}

#endif		/* FHKB LOW */

#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : ath0-ok \n");
#endif
			DTRB_DISC										/* PIO DTRB is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG dtmf-ath0:DTRB set DISC(bit ON)\n");
#endif
			basil_mc_timerset(EVT_TO_T7);
			break;
		case EVT_TO_T7:
			DTRB_NORMAL									/* PIO DTRB is High */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG dtmf-t7-TEL:DTRB set NORMAL(bit OFF)\n");
#endif
			basil_end_log();
			basil_mc_sts = STS_IDLE;
			break;
		default:
			break;
	}

	return ret;
}

char basil_mc_sts_ath1(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;

	switch(evt){
		case EVT_OK:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : ath1-ok \n");
#endif
			if ( basil_config_data.modem_mode == TEL_MODE ){
				basil_mc_timerset(EVT_TO_ATSEND);
			}
			break;
		case EVT_TO_ATSEND:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : ath1-atsend \n");
#endif
			basil_send_data("AT&R1", 1);
			basil_mc_sts = STS_ATR1;
			break;
		default:
			break;
	}

	return ret;
}

char basil_mc_sts_atr0(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;

	switch(evt){
		case EVT_OK:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atr0-ok \n");
#endif
#if 1		/* 030507 sugiyama wrote for FHKB LOW */
			if ( basil_config_data.modem_mode == FAX_MODE && (basil_mc_stsopt == EVT_LHKB_LOW || basil_mc_stsopt == EVT_FHKB_LOW) ){
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atr0-ok FHKB_LOW or LHKB_LOW \n");
#endif
#if 1		/* 030508 sugiyama wrote ath0 send */
				basil_mc_timerset(EVT_TO_ATSEND);
#else
				basil_mc_stsopt = 0;
				basil_end_log();
				LCNT_LOW									/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atr0-ok1:LCNT set LOW(bit OFF)\n");
#endif
				basil_mc_sts = STS_IDLE;
#endif		/* ath0 send */
				break;
			}
#endif		/* FHKB LOW */
			if ( basil_config_data.modem_mode == FAX_MODE &&
				(basil_mc_stsopt == EVT_TO_T6F || Basil_close_sleep_evt == EVT_TO_T6F) ){	/* for FAX MODE DTMF NONE or FAX MODE driver close*/
				if ( Basil_close_sleep_evt == EVT_TO_T6F ){
					basil_set_log( "\r\nFORCE CLOSE\r\n", 15 );	/* Logging flag check and set */
					basil_send_upper( "FORCE CLOSE", 1 );
				}
				basil_mc_stsopt = 0;
				basil_end_log();
				LCNT_LOW									/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atr0-ok2:LCNT set LOW(bit OFF)\n");
#endif
				basil_mc_sts = STS_IDLE;
				if ( Basil_close_sleep_evt == EVT_TO_T6F ){
					Basil_close_sleep_evt = 0;
					wake_up(&basil_close_wait);
				}
			}else{											/* for recv secence */
				basil_mc_timerset(EVT_TO_ATSEND);
			}
			break;
#if 1		/* 030507 sugiyama wrote for FHKB LOW */
		case EVT_FHKB_LOW:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atr0-fhkb_low \n");
#endif
			if ( basil_config_data.modem_mode == FAX_MODE ){
#if 1		/* 030508 sugiyama wrote ath0 send */				
				basil_mc_stsopt = evt;
				basil_mc_timerset(EVT_TO_ATSEND);
#else		/* ath0 send */
				basil_mc_stsopt = 0;
				basil_send_upper( "NO CARRIER", 1 );						/* 030324 sugiyama wrote for error message to chat script */
				basil_end_log();
				LCNT_LOW									/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atr0-ok1:LCNT set LOW(bit OFF)\n");
#endif
				basil_mc_sts = STS_IDLE;
#endif		/* ath0 send */		
			}
			break;
#endif		/* FHKB LOW */
		case EVT_TO_ATSEND:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atr0-atsend \n");
#endif
#if 1		/* 030508 sugiyama wrote ath0 send */				
			if ( basil_config_data.modem_mode == FAX_MODE && (basil_mc_stsopt == EVT_LHKB_LOW || basil_mc_stsopt == EVT_FHKB_LOW) ){
				basil_send_data("ATH0", 1);
				basil_mc_sts = STS_ATH0;
				break;
			}
#endif		/* ath0 send */			
			if ( basil_config_data.modem_mode == TEL_MODE && basil_mc_stsopt == EVT_TO_T6T ){	/* for TEL MODE DTMF NONE */
				basil_mc_stsopt = 0;
				basil_send_data("ATH0", 1);
				basil_mc_sts = STS_ATH0;
			}else{
				basil_send_data("ATA", 1);
				basil_mc_sts = STS_ATA;
			}
			break;
		default:
	}
	return ret;
}

char basil_mc_sts_atr1(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;

	switch(evt){
		case EVT_OK:
#if 1			/* this is a true secense */
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atr1-OK DTMFchk ON\n");
#endif
			if ( basil_config_data.modem_mode == FAX_MODE ){
				basil_mc_timerset(EVT_TO_T6F);
			}else{
				basil_mc_timerset(EVT_TO_T6T);
			}
#else			/* this is a Test secense (DTMF check NONE) */
			printk("PPP_DEBUG : atr1-OK DTMFchk NONE\n");
			basil_mc_timerset(EVT_TO_T3);
#endif
			basil_mc_sts = STS_DTMF;
			dtmf_lcnt = 0;							/* 030507 sugiyama wrote */
			break;
#if 1		/* 030507 sugiyama wrote for FHKB LOW */
		case EVT_LHKB_LOW:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atr1-LHKB send ATR0\n");
#endif
			basil_mc_stsopt = EVT_LHKB_LOW;
			basil_send_data("AT&R0", 1);
			basil_mc_sts = STS_ATR0;
			break;
#endif			
		default:
	}

	return ret;
}

char basil_mc_sts_ata(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;

	switch(evt){
		case EVT_CONNECT:
			if ( basil_mc_stsopt == EVT_FHKB_LOW ){
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : ata-CONNECT but now Resetting modem \n");
#endif
				break;
			}

#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : ata-CONNECT \n");
#endif
			basil_mc_sts = STS_CONNECT;
			basil_end_log();
			ret = 1;
			break;
#if 1		/* 030507 sugiyama wrote for FHKB LOW */
		case EVT_FHKB_LOW:
			if ( basil_config_data.modem_mode == FAX_MODE ){
				MODEM_RST_RESET;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG ata-FHKB_LO:MODEM_RESET set RESET\n");
#endif
				basil_mc_timerset(EVT_TO_T7);
				basil_mc_timerset(EVT_TO_T5);
				basil_mc_stsopt = EVT_FHKB_LOW;
			}
			break;
		case EVT_TO_T5:
			LCNT_LOW										/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG ata-T5:LCNT set LOW(bit OFF) on CON\n");
#endif
/*			basil_mc_sts = STS_IDLE;*/
			basil_send_upper( "NO CARRIER", 1 );						/* 030324 sugiyama wrote for error message to chat script */
			basil_end_log();
			basil_mc_stsopt = 0;
			basil_mc_sts = STS_IDLE;
			break;
		case EVT_TO_T7:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : ata-T7\n");
#endif			
			MODEM_RST_NORMAL;
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG atd-T7-FHKB_LO:MODEM_RESET set NORMAL\n");
#endif
			break;
#endif /* FAXMODE patch */
		default:
	}
	return ret;

}
char	atd_disc_flg=0;
char basil_mc_sts_atd(char *buf, ushort len, char evt, ushort offset)
{
	char ret = 0;
	char ret_cmp = 0;
	int i;
	static char chk_call[] = { 0x0d, 0x0a, 'C', 'A', 'L', 'L', ' ', 'T', 'I', 'M', 'E', ' ', 'O', 'U', 'T', 0x0d, 0x0a};


#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd- evt = %d\n",evt);
#endif

	switch(evt){
		case EVT_CONNECT:
			basil_mc_timerdel( EVT_TO_T4 );
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atd-connect\n");
#endif
			basil_end_log();
			basil_mc_sts = STS_CONNECT;
			ret = 1;
			break;
		case EVT_TO_T4:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atd-T4\n");
#endif
			basil_send_upper( "CALL TIME OUT", 1 );
			DTRB_DISC										/* PIO DTRB is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-t4:DTRB set DISC(bit ON)\n");
#endif
			basil_mc_timerset(EVT_TO_T7);
			atd_disc_flg = 1;
			break;
		case EVT_TO_T7:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atd-T7\n");
#endif			
			DTRB_NORMAL											/* PIO DTRB is High */
			atd_disc_flg = 0;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-t7:DTRB set NORMAL(bit OFF)\n");
#endif
#if 1	/* 030310 sugiyama wrote FAX MODE FAX OFFHOOK patch */
			if ( basil_mc_stsopt == EVT_FHKB_LOW ){
				MODEM_RST_NORMAL;
#if BASIL_PPP_DEBUG
				printk("PPP_DEBUG atd-T7-FHKB_LO:MODEM_RESET set NORMAL\n");
#endif
				break;
			}
#endif
#if 1		/* 030507 sugiyama wrote  for RING get */
			if ( basil_mc_stsopt == EVT_RING ){
				MODEM_RST_NORMAL;
#if BASIL_PPP_DEBUG
				printk("PPP_DEBUG atd-T7-EVTRING:MODEM_RESET set NORMAL\n");
#endif
				if ( basil_config_data.modem_mode == FAX_MODE )
					break;
				basil_send_upper( "NO CARRIER", 1 );						/* 030324 sugiyama wrote for error message to chat script */
			}
#endif
			basil_end_log();
			basil_mc_sts = STS_IDLE;
			
			if ( basil_config_data.modem_mode == FAX_MODE ){			
				LCNT_LOW									/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-t7:LCNT set LOW(bit OFF)\n");
#endif
			}
			break;

#if 1		/* 030507 sugiyama wrote  for RING get */
		case EVT_RING:
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : atd-ring\n");
#endif			
			MODEM_RST_RESET;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-RING:MODEM_RESET set RESET\n");
#endif
			atd_disc_flg = 1;
			basil_mc_timerset(EVT_TO_T7);
			if ( basil_config_data.modem_mode == FAX_MODE )
				basil_mc_timerset(EVT_TO_T5);
			basil_mc_stsopt = EVT_RING;
			break;
#endif

#if 1	/* 030310 sugiyama wrote FAX MODE FAX OFFHOOK patch */
		case EVT_FHKB_LOW:
			if ( basil_config_data.modem_mode == FAX_MODE ){
				MODEM_RST_RESET;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-FHKB_LO:MODEM_RESET set RESET\n");
#endif
				atd_disc_flg = 1;
				basil_mc_timerset(EVT_TO_T7);
				basil_mc_timerset(EVT_TO_T5);
				basil_mc_stsopt = EVT_FHKB_LOW;
			}
			break;
		case EVT_TO_T5:
			LCNT_LOW										/* PIO LCNT is Low */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-T5:LCNT set LOW(bit OFF) on CON\n");
#endif
			wake_up(&basil_ioctl_wait);
			basil_mc_sts = STS_IDLE;
			if ( basil_mc_stsopt == EVT_FHKB_LOW ){
				basil_send_upper( "NO CARRIER", 1 );						/* 030324 sugiyama wrote for error message to chat script */
				basil_end_log();
			}
			basil_mc_stsopt = 0;
			break;
#endif /* FAXMODE patch */
#if 1	/* 030424 sugiyama wrote */		
		case EVT_NO_CAR:
			if( atd_disc_flg == 1 ){
				break;
			}
#endif
		case EVT_ERROR:
		case EVT_BUSY:
		case EVT_NO_ANS:
		case EVT_NO_LINE:
		case EVT_LINE_USE:
		case EVT_NO_DIAL:
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-no_line\n");
#endif
			basil_mc_timerdel( EVT_TO_T4 );
			ret = 1;
			basil_end_log();
			basil_mc_sts = STS_IDLE;
			if ( basil_config_data.modem_mode == FAX_MODE ){

#if BASIL_PPP_DEBUG
printk("PPP_DEBUG atd-def:LCNT set LOW(bit OFF)\n");
#endif
				LCNT_LOW						/* PIO LCNT is High */
			}
			break;
		case EVT_INIT:
#if 1	/* 040115 sugiyama wrote */
		case EVT_LHKB_LOW:
		case EVT_DISCON:
		case EVT_ATD:
#endif
			break;
		default:
#if 1	/* 040115 sugiyama wrote */
			if ( buf == NULL ){
#if BASIL_PPP_DEBUG
				printk("PPP:Warning Incoming event which isn't assumed evt = 0x%x\n", evt);
#endif
				break;
			}
#endif
#if BASIL_PPP_DEBUG
printk("\nPPP_DEBUG, atd-def buf =");

for ( i = 0 ; i < strlen(buf) ; i ++ ){
	printk("'0x%02x',", buf[i]);
}
printk("\n");
#endif

			/* check ATDT command LOCAL ECHO */
			if ( 1 == strlen(buf) ){			/* 1byte data chack */
				 break;
			}
			if ( *buf == 'A' || *buf == 'a' ){		/* AT command check */
				if ( *(buf+1) == 'T' || *(buf+1) == 't' ){
					break;
				}
			}
#if 1		/* 030424 sugiyama wrote CALLTIMEOUT*/			
			ret_cmp=1;
			for ( i = 0 ; i < strlen(chk_call) ; i ++ ){
				if ( *(buf+i) != chk_call[i] ){
#if BASIL_PPP_DEBUG
					printk("\nPPP_DEBUG, atd-def unknown data");
#endif
					ret_cmp=0;
					break;
				}
			}
#endif			
			basil_set_log( buf, strlen(buf) );	/* Logging flag check and set */
			basil_end_log();
			if ( ret_cmp == 0 ){
				basil_mc_timerdel( EVT_TO_T4 );
				ret = 1;
				basil_mc_sts = STS_IDLE;
				if ( basil_config_data.modem_mode == FAX_MODE ){
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG atd-def:LCNT set LOW(bit OFF)\n");
#endif
					LCNT_LOW						/* PIO LCNT is High */
				}
			}
			break;
	}
	return ret;
}

char basil_mc_timerset( char no )
{
#if 1			/* 030318 sugiyama wrote : if basil_poll_flg != 1, driver closed timer start is useless*/
	if ( Basil_poll_flg != 1 && no != EVT_TO_RETRY){
		return -1 ;
	}
#endif
	if ( no >= TIMER_CNT + EVT_TO_T1 || no < EVT_TO_T1 ){
		return -1 ;
	}

	if ( basil_timer_flg[no-EVT_TO_T1] == 1 ){
		del_timer( &basil_timer[no-EVT_TO_T1] );
		spin_lock(basil_timer_flg);
		basil_timer_flg[no-EVT_TO_T1] = 0;
		spin_unlock(basil_timer_flg);
	}

	basil_timer[no-EVT_TO_T1].function = basil_mc_timer;
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : timerset TimerNO is %d , set expires is %d\n", no-EVT_TO_T1, basil_timer_data[no-EVT_TO_T1] );
#endif
	basil_timer[no-EVT_TO_T1].expires = jiffies + basil_timer_data[no-EVT_TO_T1] ;
	basil_timer[no-EVT_TO_T1].data = no ;

	add_timer( &basil_timer[no-EVT_TO_T1] );
	spin_lock(basil_timer_flg);
	basil_timer_flg[no-EVT_TO_T1] = 1;
	spin_unlock(basil_timer_flg);

	return 1;

}

char basil_mc_timerdel( char no )
{
	int i;

	if ( no == TIMER_CLEAR_ALL ){
RECHECK:		
		/* Check All timer Table */
		for ( i = 0 ; i < TIMER_CNT ; i ++ ){
			if ( basil_timer_flg[i] == 1 ){
#if BASIL_PPP_DEBUG
				printk("PPP_DEBUG : timerdel_all TableNo %d is movin'\n", i);
#endif
				if ( i == 4 || i == 7 ) {		/* T5 T7 timer */
#if BASIL_PPP_DEBUG
					printk("PPP_DEBUG : T5 or T7 timer is movin' close wait\n");
#endif
					Basil_close_sleep_evt = i + EVT_TO_T1;
					sleep_on(&basil_close_wait);
#if BASIL_PPP_DEBUG
					printk("PPP_DEBUG : T5 or T7 timer is movin' sleep out \n");
#endif
				}
#if 1					/* 030311 sugiyama wrote for mgetty restart */
				
				if ( i == 9 ){					/* Retry Timer */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG timerdel-ALL: RetryTimer is movin' goto Idle status\n");
#endif
					basil_set_log( "\r\nFORCE CLOSE\r\n", 15 );	/* Logging flag check and set */
					basil_end_log();
					basil_send_upper( "FORCE CLOSE", 1 );
					basil_mc_sts = STS_IDLE;
					MODEM_RST_NORMAL;						/* 030327 sugiyama wrote */
					if ( basil_config_data.modem_mode == FAX_MODE ){
						LCNT_LOW						/* PIO LCNT is High */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG timerdel-ALL:LCNT set LOW(bit OFF)\n");
#endif
					}
				}
#endif
				del_timer( &basil_timer[i] );
				spin_lock(basil_timer_flg);
				basil_timer_flg[i] = 0;
				spin_unlock(basil_timer_flg);
				i = 0;				/* check table count is clear */
			}
		}

		if ( basil_mc_sts == STS_DTMF){					/* if check DTMFcode now, goto DTMF check NG root quickly */
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : DTMFcode check is movin' close wait\n");
#endif
			Basil_close_sleep_evt = EVT_TO_T6F;
			basil_mc_timer(EVT_TO_T6F);
			sleep_on(&basil_close_wait);
#if BASIL_PPP_DEBUG
			printk("PPP_DEBUG : DTMFcode check is movin' sleep out\n");
#endif
			goto RECHECK;
		}
		if ( basil_mc_sts != STS_IDLE ){					/* Retry Timer */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG timerdel-ALL: All timer is stoped but status isn't idle \n");
#endif
			if ( basil_mc_sts == STS_CONNECT ){			
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG timerdel-ALL: sts=connect disconnect line \n");
#endif
				DTRB_DISC							/* 030404 sugiyama wrote */
				mdelay(basil_timer_data[EVT_TO_T7-EVT_TO_T1]*10);
				DTRB_NORMAL								/* PIO DTRB is High */
			}else{
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG timerdel-ALL: sts=%d reset modem \n", basil_mc_sts);
#endif
				MODEM_RST_RESET;						/* 030327 sugiyama wrote */
				mdelay(200);
				MODEM_RST_NORMAL;						/* 030327 sugiyama wrote */
			}
			basil_set_log( "\r\nFORCE CLOSE\r\n", 15 );	/* Logging flag check and set */
			basil_end_log();
			basil_send_upper( "FORCE CLOSE", 1 );
			basil_mc_sts = STS_IDLE;
			if ( basil_config_data.modem_mode == FAX_MODE ){
				LCNT_LOW						/* PIO LCNT is High */
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG timerdel-ALL2:LCNT set LOW(bit OFF)\n");
#endif
			}
		}
		return 1;
	}

	if ( no >= TIMER_CNT + EVT_TO_T1 || no < EVT_TO_T1 ){
		return -1 ;
	}

	if ( basil_timer_flg[no-EVT_TO_T1] == 1 ){
		del_timer( &basil_timer[no-EVT_TO_T1] );
		spin_lock(basil_timer_flg);
		basil_timer_flg[no-EVT_TO_T1] = 0;
		spin_unlock(basil_timer_flg);
		return 1;
	}else{
		return -1;
	}
}

char basil_send_data(char *cmd, char r_flg )
{
	int		size;
	char		send[128];

	size = strlen(cmd);

	/* Set send data to NoResonce Retry Buffer */
	if ( r_flg == 1 ){
		basil_mc_timerset(EVT_TO_RETRY);
		memcpy (Retry_buf, cmd, size + 1 );	/* copy data include '\0' code */
	}

	/* copy and send */
	memcpy ( send, cmd, size);
	*( send + size )= 0x0d;
	size += 1;
#if BASIL_PPP_DEBUG
	printk("PPP_DEBUG : basil_send buf = %s, \n count = %d", Retry_buf, size);
#endif
	basil_set_log(send, size);
	gs_write(basil_return_tty, 0, send, size);
	return 1;

}

char	dtmf_buffer[4];
int	buffer_idx = 0;
/* Check DTMF code */
char basil_dtmf_check(char code, char flg)
{
/*	static int	buffer_idx = 0;*/
	static int	dtmf_match_flg = 0;
	int		i;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : dtmf code 1-");
#endif
	if ( flg == 1 ){			/* reset flag is on */
		dtmf_match_flg = 0;
		buffer_idx = 0;
		dtmf_buffer[0] = 0x00;
		dtmf_buffer[1] = 0x00;
		dtmf_buffer[2] = 0x00;
		dtmf_buffer[3] = 0x00;
#if BASIL_PPP_DEBUG
		printk("\nPPP_DEBUG : reset m_flg = %d, buf_idx = %d, buf = %c,%c,%c,%c\n", dtmf_match_flg, buffer_idx, dtmf_buffer[0], dtmf_buffer[1], dtmf_buffer[2], dtmf_buffer[3]);
#endif
		return 0;
	}

	if(dtmf_match_flg){
#if BASIL_PPP_DEBUG
printk("7-");
#endif
		if(code != basil_ppp_dtmf_tbl[dtmf_match_flg - 1].name[ buffer_idx++ ]){
#if BASIL_PPP_DEBUG
printk("9-");
#endif
			dtmf_match_flg = 0;
			buffer_idx = 0;
			return -1;
		}
		if ( buffer_idx >= 4 ){
#if BASIL_PPP_DEBUG
printk("8-");
#endif
			buffer_idx = 0;
		}
	}else{
#if BASIL_PPP_DEBUG
printk("2=%d-",buffer_idx);
#endif
		dtmf_buffer[ buffer_idx++ ] = code;
#if BASIL_PPP_DEBUG
printk("3-");
#endif
		if ( buffer_idx >= 4 ){
			for ( i = 0 ; i < 4 ; i ++ ){
#if BASIL_PPP_DEBUG
printk("5-");
#endif
				if ( !(memcmp (dtmf_buffer, &(basil_ppp_dtmf_tbl[i].name[0]), 4)) ){
#if BASIL_PPP_DEBUG
printk("6-");
#endif
					dtmf_match_flg = i + 1;
					buffer_idx = 0;
					return dtmf_match_flg;
				}
			}
			buffer_idx = 0;
		}
#if BASIL_PPP_DEBUG
printk("4-");
#endif
	}

	return dtmf_match_flg;
}

char basil_check_retry( char evt )
{
	char ret = 0;
	switch ( basil_mc_sts ){
		case STS_IDLE:
			if ( evt == EVT_OK || evt == EVT_CONNECT || evt == EVT_RING)
				ret = 1;
			break;
		case STS_DTMF:
			if ( evt == EVT_OK )
				ret = 1;
			break;
		case STS_CONNECT:
			if ( evt == EVT_OK )
				ret = 1;
			break;
		case STS_ATR0:
			if ( evt == EVT_OK )
				ret = 1;
			break;
		case STS_ATR1:
			if ( evt == EVT_OK )
				ret = 1;
			break;
		case STS_ATA:
			if ( evt == EVT_CONNECT  )
				ret = 1;
			break;
		case STS_ATH0:
			if ( evt == EVT_OK )
				ret = 1;
			break;
		case STS_ATH1:
			if ( evt == EVT_OK )
				ret = 1;
			break;
		case STS_ATD:
			if ( evt == EVT_OK )
				ret = 1;
			break;
		case STS_INIT:
			if ( evt == EVT_OK )
				ret = 1;
			break;
	}
	return ret;
}


/* check Start Data logger Timing and init Flah */
void basil_chk_start_log( char evt )
{
	if ( Basil_com_log_flg != LOG_OFF ){
		return;
	}

	if ( evt == EVT_RING && basil_config_data.modem_mode == TEL_MODE && basil_ring_get == 0){
		Basil_com_log_flg = LOG_ON_RECV;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : RECV Logging start \n*");
#endif
	}else if ( evt == EVT_LHKB_LOW && basil_config_data.modem_mode == FAX_MODE ){
		Basil_com_log_flg = LOG_ON_RECV;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : RECV Logging start \n*");
#endif
	}else if ( evt == EVT_ATD ){
		Basil_com_log_flg = LOG_ON_DIAL;
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : DIAL Logging start \n*");
#endif
	}
}

/* buffer set to Data Logger */
void basil_set_log( char *buf, int size )
{
	if ( size > LOG_BUF_MAXLEN ){		/* check log data size over 67byte(LOG_BUF_MAXLEN) */
		size = LOG_BUF_MAXLEN;
	}

	/* Set receive data to communication LOG */
	if ( Basil_com_log_flg == LOG_ON_DIAL ){

		memcpy( &(Basil_com_log_dial[Basil_com_log_dialcnt][0]), buf, size );
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : recv buf DIAL LOG SET buf = %s, pos = %d, size = %d", &(Basil_com_log_dial[Basil_com_log_dialcnt][0]), Basil_com_log_dialcnt, size);
#endif
		Basil_com_log_dial[Basil_com_log_dialcnt][size] = '\0';
		Basil_com_log_dialcnt ++;
		if ( Basil_com_log_dialcnt >= LOG_BUF_MAX ){
			Basil_com_log_dialcnt = 0;
		}
	}else if ( Basil_com_log_flg == LOG_ON_RECV ){
		memcpy( &(Basil_com_log_recv[Basil_com_log_recvcnt][0]), buf, size );
#if BASIL_PPP_DEBUG
printk("PPP_DEBUG : recv buf RECV LOG SET buf = %s, pos = %d, size = %d", &(Basil_com_log_recv[Basil_com_log_recvcnt][0]), Basil_com_log_recvcnt, size);
#endif
		Basil_com_log_recv[Basil_com_log_recvcnt][size] = '\0';
		Basil_com_log_recvcnt ++;
		if ( Basil_com_log_recvcnt >= LOG_BUF_MAX ){
			Basil_com_log_recvcnt = 0;
		}
	}

}

void basil_end_log( void )
{
#if BASIL_PPP_DEBUG

	char	dbg_buf[LOG_BUF_MAX][LOG_BUF_MAXLEN];
	int	dbg_len;
	int	j,i;
#endif
	if ( Basil_com_log_flg == LOG_OFF )
		return;

#if BASIL_PPP_DEBUG
	if ( Basil_com_log_flg == LOG_ON_DIAL ){
		printk("PPP_DEBUG : DIAL Logging end \n LOG DATA \n");
  memcpy( dbg_buf, Basil_com_log_dial, sizeof ( Basil_com_log_dial ) );
	}else if( Basil_com_log_flg == LOG_ON_RECV ){
		printk("PPP_DEBUG : RECV Logging end \n LOG DATA \n");
  memcpy( dbg_buf, Basil_com_log_recv, sizeof ( Basil_com_log_recv ) );
	}
	for ( i = 0 ; i < 10 ; i ++ ){
		printk("%d:", i+1);
		dbg_len = strlen(dbg_buf[i]);
		for ( j = 0; j < dbg_len ; j ++ ){
			if ( !(dbg_buf[i][j] == 0x0d || dbg_buf[i][j] == 0x0a) )
				printk("%c", dbg_buf[i][j] );
		}
		printk("\n");
	}
	printk("log end \n");
#endif
	Basil_com_log_flg = LOG_OFF;
}

void basil_send_upper( char *buf, char add_flg )
{
	int len, i;
	char ch;
	unsigned long	flags;
	char	send_buf[TTY_FLIPBUF_SIZE];
#if 0	/* 020930 CCI sugiyama : Compiler Warining message */
	char	offset;
#else
	int	offset;
#endif
	if ( add_flg == 1 ){
		offset = 2;
	}else{
		offset = 0;
	}


	len = strlen(buf);
	if ( len >= TTY_FLIPBUF_SIZE ){
		return;
	}

	memcpy( &send_buf[offset], buf, len );

	if ( add_flg == 1 ){
		send_buf[0] = 0x0d;
		send_buf[1] = 0x0a;
		send_buf[len + 2] = 0x0d;
		send_buf[len + 3] = 0x0a;
		len += 4;
	}

	save_flags(flags);
	cli();

	for ( i = 0 ; i < len  ; i ++ ){
		ch = send_buf[i];
		*basil_return_tty->flip.char_buf_ptr++ = ch;
		*basil_return_tty->flip.flag_buf_ptr++ = 0;
		basil_return_tty->flip.count++;
	}
	restore_flags(flags);

	tty_flip_buffer_push(basil_return_tty);
}
