/*
 * linux/arch/mips/tx4925/common/tx4925_setup.c
 *
 * common tx4925 setup stuff
 *
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/module.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <linux/timex.h>
#include <linux/malloc.h>
#include <linux/random.h>
#include <linux/irq.h>
#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <asm/time.h>
#include <asm/time.h>
#include <asm/tx4925/tx4925.h>


#undef DEBUG

void __init tx4925_early_fw_fixup( void );
void __init tx4925_setup( void );
void __init tx4925_time_init( void );
void __init tx4925_timer_setup( struct irqaction *irq );
void dump_cp0( char* key );


void (*__wbflush) (void);


static void 
tx4925_write_buffer_flush( void )
{
  __asm__ __volatile__
  ( 
    "sync\n\t"
    "nop\n\t"
    "loop: bc0f loop\n\t"
    "nop\n\t"
  );
}


void __init 
tx4925_early_fw_fixup( void )
{
  #ifdef CONFIG_RICOH_BASIL_S1
  {
    extern void basil_s1_early_fw_fixup(void);
    basil_s1_early_fw_fixup();
  }
  #endif

  return;
}


void __init 
tx4925_setup( void )
{
  board_time_init   = tx4925_time_init;
  board_timer_setup = tx4925_timer_setup;
  __wbflush         = tx4925_write_buffer_flush;

  #ifdef CONFIG_RICOH_BASIL_S1
  {
    extern void basil_s1_setup(void);
    basil_s1_setup();
  }
  #endif

  return;
}


void __init
tx4925_time_init( void )
{

  #ifdef CONFIG_RICOH_BASIL_S1
  {
    extern void basil_s1_time_init(void);
    basil_s1_time_init();
  }
  #endif

  #ifdef CONFIG_REMOTE_DEBUG
  {
    printk( "Calling breakpoint() -- start remote kgdb\n" );
    set_debug_traps();
    breakpoint();
    printk( "Calling breakpoint() -- done\n" );
  }
  #endif

  return;
}


void __init
tx4925_timer_setup( struct irqaction *irq )
{
  #ifndef CONFIG_RICOH_BASIL_S1
  u32 count;
  u32 c1;
  u32 c2;

  setup_irq( TX4925_IRQ_CPU_TIMER, irq );

  /* to generate the first timer interrupt */
  c1 = read_32bit_cp0_register( CP0_COUNT );
  count  = c1 + ( mips_counter_frequency / HZ );
  write_32bit_cp0_register( CP0_COMPARE, count );
  c2 = read_32bit_cp0_register( CP0_COUNT );
  #endif

  #ifdef CONFIG_RICOH_BASIL_S1
  {
    extern void basil_s1_timer_setup( struct irqaction *irq );
    basil_s1_timer_setup( irq );
  }
  #endif

  return;
}


#ifdef DEBUG
void
print_cp0( char* key, int num, char* name, u32 val )
{
  printk( "%s cp0:%02d:%s=0x%08x\n", key, num, name, val );
  return;
}


void
dump_cp0( char* key )
{
  if ( key == NULL ) key = "";

  print_cp0( key,  0, "INDEX   ", read_32bit_cp0_register(CP0_INDEX   )              );
  print_cp0( key,  2, "ENTRYLO1", read_32bit_cp0_register(CP0_ENTRYLO0)              );
  print_cp0( key,  3, "ENTRYLO2", read_32bit_cp0_register(CP0_ENTRYLO1)              );
  print_cp0( key,  4, "CONTEXT ", read_32bit_cp0_register(CP0_CONTEXT )              );
  print_cp0( key,  5, "PAGEMASK", read_32bit_cp0_register(CP0_PAGEMASK)              );
  print_cp0( key,  6, "WIRED   ", read_32bit_cp0_register(CP0_WIRED   )              );
  print_cp0( key,  8, "BADVADDR", read_32bit_cp0_register(CP0_BADVADDR)              );
  print_cp0( key,  9, "COUNT   ", read_32bit_cp0_register(CP0_COUNT   )              );
  print_cp0( key, 10, "ENTRYHI ", read_32bit_cp0_register(CP0_ENTRYHI )              );
  print_cp0( key, 11, "COMPARE ", read_32bit_cp0_register(CP0_COMPARE )              );
  print_cp0( key, 12, "STATUS  ", read_32bit_cp0_register(CP0_STATUS  )              );
  print_cp0( key, 13, "CAUSE   ", read_32bit_cp0_register(CP0_CAUSE   ) & 0xffff87ff );
  print_cp0( key, 16, "CONFIG  ", read_32bit_cp0_register(CP0_CONFIG  )              );

  return;
}


void
print_pic( char* key, u32 reg, char* name )
{
  printk( "%s pic:0x%08x:%s=0x%08x\n", key, reg, name, TX4925_RD(reg) );
  return;
}


void
dump_pic( char* key )
{
  if ( key == NULL ) key = "";

  print_pic( key,  TX4925_IRC_IRDEN,  "IRDEN    " );
  print_pic( key,  TX4925_IRC_IRDM0,  "IRDM0    " );
  print_pic( key,  TX4925_IRC_IRDM1,  "IRDM1    " );

  print_pic( key,  TX4925_IRC_IRLVL0, "IRLVL0   " );
  print_pic( key,  TX4925_IRC_IRLVL1, "IRLVL1   " );
  print_pic( key,  TX4925_IRC_IRLVL2, "IRLVL2   " );
  print_pic( key,  TX4925_IRC_IRLVL3, "IRLVL3   " );
  print_pic( key,  TX4925_IRC_IRLVL4, "IRLVL4   " );
  print_pic( key,  TX4925_IRC_IRLVL5, "IRLVL5   " );
  print_pic( key,  TX4925_IRC_IRLVL6, "IRLVL6   " );
  print_pic( key,  TX4925_IRC_IRLVL7, "IRLVL7   " );

  print_pic( key,  TX4925_IRC_IRMASK, "IRMSK    " );
  print_pic( key,  TX4925_IRC_IREDC,  "IREDC    " );
  print_pic( key,  TX4925_IRC_IRPND,  "IRPND    " );
  print_pic( key,  TX4925_IRC_IRCS,   "IRCS     " );

  return;
}


void 
print_addr( char* hdr, char* key, u32 addr )
{
  printk( "%s %s:0x%08x=0x%08x\n", hdr, key, addr, TX4925_RD32(addr) );
  return;
}


void
dump_180( char* key )
{
  u32 i;

  for ( i = 0x80000180; i < 0x80000180+0x80; i+=4 )
  {
    print_addr( "180", key, i );
  }
  return;
}


void
dump_eh0( char* key )
{
  int i;
  extern unsigned long exception_handlers[];

  for ( i = (int)exception_handlers; i < (int)(exception_handlers+20); i+=4 )
  {
    print_addr( "eh0", key, i );
  }

  return;
}

void
pk0( void )
{
  volatile u32 val;

  __asm__ __volatile__
  (
    "ori %0, $26, 0"
    : "=r" (val)
  );
  printk( "k0=[0x%08x]\n", val );
}
#endif
