/*
 *
 * BRIEF MODULE DESCRIPTION
 *      Board specific pci fixups for the Basil-S1
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author: MontaVista Software, Inc.
 *              ppopov@mvista.com or source@mvista.com
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <linux/config.h>

#ifdef CONFIG_PCI

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>

#include <asm/tx4925/tx4925.h>
#include <asm/tx4925/tx4925_pci.h>
#include <asm/tx4925/basil_s1/basil_s1.h>

#undef  DEBUG
#ifdef  DEBUG
#define DBG(x...)       printk(x)
#else
#define DBG(x...)       
#endif

void __init pcibios_fixup_resources(struct pci_dev *dev)
{
    /* will need to fixup IO resources */
}

void __init pcibios_fixup(void)
{
    /* nothing to do here */
}

int pci_get_irq(struct pci_dev *dev, int pin)
{
    unsigned char irq = pin;

    DBG("pci_get_irq: pin is %d\n",pin);
    /* IRQ rotation */
    irq--;  /* 0-3 */
    if (dev->bus->parent == NULL &&
        (PCI_SLOT(dev->devfn) == TX4925_PCIC_IDSEL_AD_TO_SLOT(11))) {
        irq = TX4925_IRQ_IRC_INT0;		/* LANC#0 use INT0 */
    } else if(dev->bus->parent == NULL &&
        (PCI_SLOT(dev->devfn) == TX4925_PCIC_IDSEL_AD_TO_SLOT(12))) {
        irq = TX4925_IRQ_IRC_INT1;		/* LANC#1 use INT1 */
    } else if(dev->bus->parent == NULL &&
        (PCI_SLOT(dev->devfn) == TX4925_PCIC_IDSEL_AD_TO_SLOT(13))) {
        irq = TX4925_IRQ_IRC_INT4;		/* Opt-Card use INT4 */
    }

    DBG("assigned irq %d\n",irq);
    return irq;
}


#ifdef DEBUG
void
do_it( u32 offset, u32 reg )
{
  volatile u32 a1;
  volatile u32 v1;

  a1 = 0xff1f0000 + offset + reg;

  v1 = *(volatile u32*)a1;

  if ( v1 ) printk( "TX4925 0x%08x 0x%08x\n", a1, v1 );
}
void
do_it1( u32 base, u32 r )
{
  do_it( base, r );
}
void
do_it2( u32 base, u32 start, u32 stop )
{
  u32 r;

  for ( r = start; r <= stop; r+=4 )
  {
    do_it( base, r );
  }
}
void 
dump_config( void )
{
  unsigned long id;
  unsigned long j; 
  struct pci_dev *dev;

  printk( "----------------------pci\n" );
  pci_for_each_dev( dev ) 
  {
    for ( j = 0; j < 64; j++ )
    {
       pci_read_config_dword( dev, j*4, &id );  
       if ( id == 0 ) continue;
       printk( "dev 0x%02x 0x%02x:0x%02x -- 0x%02x-0x%02x 0x%08x\n", 
               dev->devfn, PCI_SLOT(dev->devfn), PCI_FUNC(dev->devfn), 
               (j*4)+3, (j*4), id );
    }
    printk( "dev 0x%02x \n", dev->devfn );
  }
  printk( "----------------------sdram\n" );
  do_it2( 0x8000, 0x00, 0x0c ); 
  do_it1( 0x8000, 0x20 ); 
  do_it1( 0x8000, 0x2c ); 
  printk( "----------------------ebus\n" );
  do_it2( 0x9000, 0x00, 0x3c ); 
  printk( "----------------------chi\n" );
  do_it2( 0xa800, 0x00, 0x30 ); 
  printk( "----------------------dmac\n" );
  do_it2( 0xb000, 0x00, 0x7c ); 
  do_it2( 0xb000, 0xa4, 0xa8 ); 
  printk( "----------------------ndfmc\n" );
  do_it2( 0xc000, 0x00, 0x18 ); 
  do_it1( 0xc000, 0x24 ); 
  /* b1xx */ 
  printk( "----------------------pci\n" );
  /* d */ 
  printk( "----------------------cfg\n" );
  do_it2( 0xe000, 0x00, 0x34 ); 
  printk( "----------------------timers\n" );
  do_it2( 0xf000, 0x00, 0x10 ); 
  do_it1( 0xf000, 0x20 ); 
  do_it1( 0xf000, 0x30 ); 
  do_it1( 0xf000, 0xf0 ); 
  do_it2( 0xf100, 0x00, 0x10 ); 
  do_it1( 0xf100, 0x20 ); 
  do_it1( 0xf100, 0x30 ); 
  do_it1( 0xf100, 0xf0 ); 
  do_it2( 0xf200, 0x00, 0x10 ); 
  do_it1( 0xf200, 0x20 ); 
  do_it1( 0xf200, 0x30 ); 
  do_it1( 0xf200, 0xf0 ); 
  printk( "----------------------serial\n" );
  do_it2( 0xf300, 0x00, 0x20 ); 
  do_it2( 0xf400, 0x00, 0x20 ); 
  printk( "----------------------parallel\n" );
  do_it2( 0xf500, 0x00, 0x0c );
  printk( "----------------------pic\n" );
  do_it2( 0xf600, 0x00, 0x08 );
  do_it2( 0xf600, 0x10, 0x2c );
  do_it1( 0xf600, 0x40 );
  do_it1( 0xf600, 0x60 );
  do_it1( 0xf600, 0x80 );
  do_it1( 0xf600, 0xa0 );
  printk( "----------------------aclink\n" );
  do_it2( 0xf700, 0x00, 0x08 );
  do_it2( 0xf700, 0x10, 0x20 );
  do_it2( 0xf700, 0x40, 0x50 );
  do_it2( 0xf700, 0x80, 0x84 );
  do_it2( 0xf700, 0xa0, 0xb0 );
  do_it2( 0xf700, 0xb8, 0xbc );
  do_it1( 0xf700, 0xfc );
  printk( "----------------------spi\n" );
  do_it2( 0xf800, 0x00, 0x1c );
  printk( "----------------------rtc\n" );
  do_it2( 0xf900, 0x00, 0x14 );
  printk( "----------------------done\n" );
}
#endif


void __init pcibios_fixup_irqs(void)
{
    unsigned char pin;
    unsigned char irq;
    struct pci_dev *dev;
    unsigned int id;

    pci_for_each_dev( dev ) 
    {
        DBG( "FIXUP:\n" );
        DBG( " devfn=0x%02x (0x%02x:0x%02x)\n", 
              dev->devfn, PCI_SLOT(dev->devfn), PCI_FUNC(dev->devfn) );

        pci_read_config_dword( dev, PCI_VENDOR_ID, &id );
        DBG( " id=0x%08x\n", id );

        pci_read_config_byte( dev, PCI_INTERRUPT_LINE, &irq );
        DBG( " line=0x%02x/%d\n", irq, irq );

        pci_read_config_byte( dev, PCI_INTERRUPT_PIN, &pin );
        DBG( " pin=%d\n", pin );

        #ifdef DEBUG
        {
        unsigned int tmp;
        pci_read_config_dword(dev, 0x10, &tmp); DBG(" bar0:0x10=0x%08x\n", tmp );
        pci_read_config_dword(dev, 0x14, &tmp); DBG(" bar1:0x14=0x%08x\n", tmp );
        pci_read_config_dword(dev, 0x1c, &tmp); DBG(" bar2:0x1c=0x%08x\n", tmp );
        pci_read_config_dword(dev, 0x20, &tmp); DBG(" bar3:0x20=0x%08x\n", tmp );
        pci_read_config_dword(dev, 0x24, &tmp); DBG(" bar4:0x24=0x%08x\n", tmp );
        }
        #endif

        irq = 0;

        if ( pin == 0 ) {
            DBG( " auto irq (now=%d) -- skipping pin=0\n", irq );
        }
        else if ( irq ) {
            DBG( " auto irq (now=%d) -- skipping hardcoded irq\n", irq );
        }
        else {
            DBG( " auto irq (was=%d)\n", irq );
            irq = pci_get_irq( dev, pin );
            pci_write_config_byte( dev, PCI_INTERRUPT_LINE, irq );
            dev->irq = irq;
            DBG( " auto irq (now=%d)\n", irq );
        }

        pci_read_config_byte( dev, PCI_INTERRUPT_LINE, &irq );
        printk( KERN_INFO "PCI: 0x%02x:0x%02x(0x%02x,0x%02x) IRQ=%d\n",
                dev->bus->number, dev->devfn, PCI_SLOT(dev->devfn),
	        PCI_FUNC(dev->devfn), irq );

    }

}
#endif /* CONFIG_PCI */
