/*..:....1....:....2....:....3....:....4....:....5....:....6....:....7....:....
 *
 * arch/ppc/gt64260/gt_mpsc.h
 *
 * UART driver for Galileo GT-64260 MPSC
 *
 * Author: Chris Zankel <chris@mvista.com>
 *
 * Copyright 2001 MontaVista Software Inc.
 *
 * I used the serial.c driver and the arch/ppc/8xx_io/uart driver
 * as a framework. Give credit to those guys.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */ 

/*
 * Receive and Transmit Descpritors
 */

typedef struct {
	volatile u32 bufsize:16;
	volatile u32 bytecnt:16;
	volatile u32 cmd_stat;
	volatile u32 next_desc_ptr;
	volatile u32 buffer;	/* physical address (for the MPSC) */
} gt_rx_descriptor_t;

typedef struct {
	volatile u32 bytecnt:16;
	volatile u32 shadow:16;
	volatile u32 cmd_stat;
	volatile u32 next_desc_ptr;
	volatile u32 buffer;
} gt_tx_descriptor_t;

#define SERIAL_MAGIC 0x5301
