/*
 * BRIEF MODULE DESCRIPTION
 *	Interrupt dispatcher for NEC VR4122 CPU core.
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author Yoichi Yuasa
 *		yyuasa@mvista.com or source@mvista.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <asm/asm.h>
#include <asm/regdef.h>
#include <asm/mipsregs.h>
#include <asm/stackframe.h>
#include <asm/vr4122/vr4122.h>

		.text
		.set	noreorder

		.align	5
		NESTED(vr4122_handle_int, PT_SIZE, ra)
		.set	noat
		SAVE_ALL
		CLI
		.set	at
		.set	noreorder

		/*
		 * Get the pending interrupts
		 */
		mfc0	t0, CP0_CAUSE
		mfc0	t1, CP0_STATUS
		andi	t0, 0xff00
		and	t0, t0, t1

		andi	t1, t0, CAUSEF_IP7	# timer interrupt
		beqz	t1, 1f
		li	a0, VR4122_IRQ_TIMER
		jal	ll_timer_interrupt
		move	a1, sp
		j	ret_from_irq

1:
		andi	t1, t0, 0x7800		# check for IP3-6
		beqz	t1, 2f

		andi	t1, t0, CAUSEF_IP3	# check for IP3
		bnez	t1, handle_it
		li	a0, VR4122_IRQ_INT1

		andi	t1, t0, CAUSEF_IP4	# check for IP4
		bnez	t1, handle_it
		li	a0, VR4122_IRQ_INT2

		andi	t1, t0, CAUSEF_IP5	# check for IP5
		bnez	t1, handle_it
		li	a0, VR4122_IRQ_INT3

		andi	t1, t0, CAUSEF_IP6	# check for IP6
		bnez	t1, handle_it
		li	a0, VR4122_IRQ_INT4

2:
		andi	t1, t0, CAUSEF_IP2	# check for IP2
		beqz	t1, 3f
		move	a0, sp
		jal	icu_irqdispatch
		nop
		j	ret_from_irq
		nop

3:
		andi	t1, t0, CAUSEF_IP0	# check for IP0
		bnez	t1, handle_it
		li	a0, VR4122_IRQ_SW1

		andi	t1, t0, CAUSEF_IP1	# check for IP1
		bnez	t1, handle_it
		li	a0, VR4122_IRQ_SW2

		j	spurious_interrupt
		nop

handle_it:
		jal	do_IRQ
		move	a1, sp
		j	ret_from_irq
		END(vr4122_handle_int)
