/*
 * linux/arch/mips/tx4927/toshiba_rbtx4927/toshiba_rbtx4927_prom.c
 *
 * rbtx4927 specific prom routines
 *
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>

#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/tx4927/tx4927.h>

#ifndef CONFIG_CMDLINE_BOOL
#define CONFIG_CMDLINE ""
#endif

/* f/w doesn't pass any args to linux */
char arcs_cmdline[COMMAND_LINE_SIZE] = CONFIG_CMDLINE;


void __init 
prom_init(int argc, const char **arg)
{
  extern int tx4927_get_mem_size( void );
  int msize;

  mips_machgroup = MACH_GROUP_TOSHIBA;
  mips_machtype  = MACH_TOSHIBA_RBTX4927;

  msize = tx4927_get_mem_size();
  add_memory_region( 0, msize << 20, BOOT_MEM_RAM );

  return;
}


void __init 
prom_free_prom_memory(void)
{
  return;
}


void __init 
prom_fixup_mem_map(unsigned long start, unsigned long end)
{
  return;
}

const char*
get_system_type( void )
{
  return "Toshiba RBTX4927";
}
