/*
 *
 * BRIEF MODULE DESCRIPTION
 *	RC32300 reset routines.
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author: MontaVista Software, Inc.
 *         	stevel@mvista.com or source@mvista.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/sched.h>
#include <linux/mm.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include <asm/processor.h>
#include <asm/reboot.h>
#include <asm/system.h>
#include <asm/rc32300/rc32300.h>

void rc32300_restart(char *command)
{
	set_cp0_status((ST0_BEV | ST0_ERL));
	set_cp0_config(CONF_CM_UNCACHED);
	flush_cache_all();
	write_32bit_cp0_register(CP0_WIRED, 0);

#ifdef CONFIG_MIPS_RC32334
	// Trigger the WatchDog Timer (Timer 3) to warm reset
	rc32300_writel(0, TIMER0_CNTL + 3*TIMER_REG_OFFSET);
	rc32300_writel(0xd8, CPU_IP_BUSERR_CNTL);
	rc32300_writel(0, TIMER0_COUNT + 3*TIMER_REG_OFFSET);
	rc32300_writel(2, TIMER0_COMPARE + 3*TIMER_REG_OFFSET);
	rc32300_writel(1, TIMER0_CNTL + 3*TIMER_REG_OFFSET);
#elif defined (CONFIG_MIPS_RC32355)
	rc32300_writel(0x80000001, RESET_CNTL);
#else
	__asm__ __volatile__("jr\t%0"::"r"(0xbfc00000));
#endif
}

void rc32300_halt(void)
{
	printk(KERN_NOTICE "\n** You can safely turn off the power\n");
	while (1)
		__asm__(".set\tmips3\n\t"
	                "wait\n\t"
			".set\tmips0");
}

void rc32300_power_off(void)
{
	rc32300_halt();
}
