#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#define BASIL_BIN_MAGIC 0x123455aa

int main(int argc, char **argv) {
	int infile, outfile;
	off_t size;

	unsigned int dst_addr, kernel_entry, magic = BASIL_BIN_MAGIC;

	unsigned char buf[512];
	size_t buf_size;

	if (argc != 5) {
		fprintf(stderr, "Usage: bin2vrc [input filename] [output filename] [dst addres] [kernel entry]\n");
		exit(1);
	}

	if ((infile = open(argv[1], O_RDONLY)) < 0) {
		fprintf(stderr, "Cannot open input file\n");
		exit(1);
	}

	if ((outfile = open(argv[2], O_CREAT|O_WRONLY|O_TRUNC, S_IRWXU|S_IRWXG|S_IRWXO)) < 0) {
		fprintf(stderr, "Cannot open output file\n");
		exit(1);
	}

	if ((size = lseek(infile, 0, SEEK_END)) < 0) {
		fprintf(stderr, "Cannot seek input file\n");
		exit(1);
	}

	if (lseek(infile, 0, SEEK_SET) < 0) {
		fprintf(stderr, "Cannot seek input file\n");
		exit(1);
	}

	if (sizeof(off_t) != write(outfile, (void *)&size, sizeof(off_t))) {
		fprintf(stderr, "Cannot write output file\n");
		exit(1);
	}

	if ((dst_addr = strtoul(argv[3], NULL, 16)) == ULONG_MAX) {
		fprintf(stderr, "dst address error\n");
		exit(1);
	}
	if (sizeof(unsigned int) != write(outfile, (void *)&dst_addr, (size_t)sizeof(unsigned int))) {
		fprintf(stderr, "Cannot write output file\n");
		exit(1);
	}

	if ((kernel_entry = strtoul(argv[4], NULL, 16)) == ULONG_MAX) {
		fprintf(stderr, "kernel entry error\n");
		exit(1);
	}

	if (sizeof(unsigned int) != write(outfile, (void *)&kernel_entry, (size_t)sizeof(unsigned int))) {
		fprintf(stderr, "Cannot write output file\n");
		exit(1);
	}

	while(size > 0) {
		if ((buf_size = read(infile, (void *)buf, (size_t)512)) == -1) {
			fprintf(stderr, "Read error\n");
			exit(1);
		}

		if(buf_size != write(outfile, (void *)buf, buf_size)) {
			fprintf(stderr, "Write error\n");
			exit(1);
		}
		size -= 512;
	}

	if (sizeof(unsigned int) != write(outfile, (void *)&magic, (size_t)sizeof(unsigned int))) {
		fprintf(stderr, "Cannot write output file\n");
		exit(1);
	}

	close(infile);
	close(outfile);
	exit(0);
}
