//全体変数：ページングする対象
var paging = new showPages("paging");

/**
 * 検索画面のメイン関数
 */
function searchBooks()
{
	try {
		var searchWords = getKeyWords();
		var searchBookName = get_key_from_url()["bookname"];
		var searchRange = get_key_from_url()["fromSeachResultPage"];
		
		// 検索ワード変数の取得
		var w = window.location.search.substring(0,5);
		
		//検索ワードと検索対象分冊を既に表示する。
		if (w == "?word")
		{
			var wordDisplay = get_key_from_url()["word"];
			if (wordDisplay == null || typeof(wordDisplay) == "undefined") 
			{
				wordDisplay = "";
			}
			document.getElementById("seek").value = wordDisplay;
		}
		else
		{
			var seekDisplay = get_key_from_url()["seek"];
			if (seekDisplay == null || typeof(seekDisplay) == "undefined") 
			{
				seekDisplay = "";
			}
			document.getElementById("seek").value = seekDisplay;
		}
		//マニュアル一覧ある場合、分冊プルダウンを表示する。
		
		displayBooks();
		for (i = 0; i < document.getElementById("selectbook").options.length; i++)
		{
			if ((document.getElementById("selectbook").options[i].value == searchBookName) && (searchRange == 1))
			{
				document.getElementById("selectbook").options[i].selected = "selected";
				break;
			}
		}
		
		//検索ワードを正規化する。
		var regSearchWords = new Array();
		var noRegSearchWords = new Array();
		for (y = 0; y < searchWords.length; y++)
		{
			
			var tmp = searchWords[y].toLowerCase();
			tmp =  removeSpace(tmp);
			tmp = dealOtherLanguageMark(tmp);
			
			if (tmp.length > 0) 
			{
				regSearchWords[regSearchWords.length] = tmp;
				noRegSearchWords[noRegSearchWords.length] = searchWords[y];
			}
		}
		//検索ワードが4ワード以上、空白、またはスペースのみの場合、エラーを表示する。
		if (regSearchWords.length >= 4 || regSearchWords.length == 0)
		{
			document.getElementById("errorMessage").style.display = "block";
			var innerHtml = '';
			if (regSearchWords.length >= 4)
			{
				var messages = "Zostało użytych za dużo słów kluczowych.\nWyszukaj 3 lub mniej słów kluczowych.";
				var messArray = messages.split("\n");
				for (i = 0; i < messArray.length; i++)
				{
					innerHtml += '<p>' + escapeHTML(messArray[i]) + '</p>';
				}
			}
			else  if (regSearchWords.length == 0 && document.getElementById("seek").value.length != 0) 
			{
				var messages = "Wpisz wyszukiwane słowo kluczowe.";
				var messArray = messages.split("\n");
				for (i = 0; i < messArray.length; i++)
				{
					innerHtml += '<p>' + escapeHTML(messArray[i]) + '</p>';
				}
				
			}
			else if (regSearchWords.length == 0 && document.getElementById("seek").value.length == 0) 
			{
				var messages = "Wpisz szukane słowo kluczowe.";
				var messArray = messages.split("\n");
				for (i = 0; i < messArray.length; i++)
				{
					innerHtml += '<p>' + escapeHTML(messArray[i]) + '</p>';
				}
			}
			document.getElementById("errorMessage").innerHTML = innerHtml;
			document.getElementById("searchResultText").style.visibility = "hidden";
			return;
		}
		//関連語・類義語の表示(検索ワードが1つの場合のみ表示する)
		//関連語・類義語のキーは正規化されている。
		if (regSearchWords.length ==1 && regSearchWords[0].length != 0) 
		{
			// 検索画面から検索する場合
			if (searchRange == 1)
			{
				relatedAndSynonym(regSearchWords[0], searchBookName, searchRange, noRegSearchWords[0]);
    			} 
			// 検索画面以外の場合は全分冊の検索になる
			else 
			{
				relatedAndSynonym(regSearchWords[0], "", searchRange, noRegSearchWords[0]);
			}
		}
		//検索ワードが複数の場合表示しない
		else if (regSearchWords.length > 1)
		{
			document.getElementById("relatedAndSynonym").style.display = "none";
		}
		//検索結果を取得
		var searchresult = new Array();
		// 検索画面から検索する場合
		if (searchRange == 1)
		{
			searchresult = search(regSearchWords, searchBookName);
		} 
		// 検索画面以外の場合は全分冊の検索になる
		else 
		{
			searchresult = search(regSearchWords, "");
		}
		//検索結果件数の表示
		document.getElementById("pageCount").innerHTML = searchresult.length;
		//エラーメッセージの表示・非表示:最大件数以上或いは0件の場合エラーを表示する
		if ((searchresult.length == 0) || (searchresult.length == 200 && overMaxCountFlag))
		{
			document.getElementById("errorMessage").style.display = "block";
			var innerHtml = '';
			if (searchresult.length == 0)
			{
				var messages = "Nie została znaleziona żadna strona zawierająca słowo kluczowe.";
				var messArray = messages.split("\n");
				for (i = 0; i < messArray.length; i++)
				{
					innerHtml += '<p>' + escapeHTML(messArray[i]) + '</p>';
				}
				document.getElementById("errorMessage").innerHTML = innerHtml;
				return;
			}
			else if (searchresult.length == 200 && overMaxCountFlag) 
			{
				var messages = "Znaleziono więcej niż % wyników. \nWyświetlono % istotnych wyników.\nWpisz dodatkowe słowo kluczowe lub wyszukaj z innym słowem kluczowym aby zawęzić wyszukiwanie.";
				var re = new RegExp("%", "g");
				messages = messages.replace(re, "200");
				var messArray = messages.split("\n");
				for (i = 0; i < messArray.length; i++)
				{
					innerHtml += '<p>' + escapeHTML(messArray[i]) + '</p>';
				}
				document.getElementById("errorMessage").innerHTML = innerHtml;
			}
		}
		else
		{
			document.getElementById("errorMessage").style.display = "none";
		}
		//結果をソートする。
		searchresult = sortResult(searchresult);
		//要約を取得する
		var summarys = getTextSummary(searchresult, regSearchWords, noRegSearchWords);
		//検索結果表示
		paging.pageCount = Math.ceil(searchresult.length / 10);
		paging.showpage = 5;
		paging.searchResult = searchresult;
		paging.summarys = summarys;
		paging.printHtml();
		//ハイライト表示
		change();
	} catch (error) {
	} finally {
		adjust();
	}
}
/*
* adjust the width of the select box
*/
function adjust() {

    var MacFireFox = false;
    var ua = navigator.userAgent.toLowerCase();
    if (ua.indexOf("mac") != -1 && ua.indexOf("firefox") != -1) {
	MacFireFox = true;
    }
    var isOpera, isSafari = false;
    if(typeof(window.opera) != 'undefined') isOpera = true;					
    if(navigator.userAgent.indexOf('Safari') > -1 && navigator.userAgent.indexOf('Chrome') == -1) isSafari = true;					
    var tmp_s = document.getElementById("selectbook");
    setTimeout(function(){
	var m = $(tmp_s).innerWidth();
	if (!isSafari && !isOpera) m+= 2;
	m = Math.min(m, 404);
	if (!MacFireFox) 
	    $(tmp_s).width(m + 'px');
	else {
	    m = Math.min($(tmp_s).outerWidth(), 404);
	    $(tmp_s).width(m + 'px');
	}
    }, 0 * 1000); // need setTimeout for IE6.

    // To fix cursor. 
    $(".linkimage").css('cursor', 'pointer');

    return;
}

/**
 * マニュアル一覧ある場合、分冊プルダウンを表示する。
 *books.length
 */
function displayBooks()
{
	document.getElementById("selectbook").options[0] = new Option('Wszystkie książki', '');
	document.getElementById("selectbook").options[0].selected = "selected";
	for (var i = 0; i < books.length; i++)
	{
		document.getElementById("selectbook").options[i + 1] = new Option(books[i].bookname, books[i].bookFolderName);
	}
}
/**
 * 関連語・類義語の表示(検索ワードが1つの場合のみ表示する)
 */
function getNewHash() {
        var newhash = location.hash.replace(/^#/, "");
	return('#' + Math.min(0, newhash-1));
}

function relatedAndSynonym(searchWord, searchBookName, searchRange, noRegSearchWord)
{
	var relatedWord = searchRelatedWord(searchWord, searchBookName);
	var synonym = searchSynonym(searchWord, searchBookName);
	if (relatedWord.length > 0 || synonym.length > 0)
	{
		document.getElementById("relatedAndSynonym").style.display = "block";
	}
	else if(relatedWord.length == 0 && synonym.length == 0)
	{
		document.getElementById("relatedAndSynonym").style.display = "none";
	}
	var bannerInnerHTML = "";
	var key = get_key_from_url();
	var backto = key["backto"];
	if ( backto == null || backto == "" || backto == undefined) {
		backto="";
	}
	//関連語の表示
	if (synonym.length > 0)
	{
		bannerInnerHTML += '<dl class="synonym"><dt>';
		bannerInnerHTML += escapeHTML('Wyszukaj z podobnym słowem kluczowym:');
		bannerInnerHTML += '</dt>';
		for (i = 0; i < synonym.length; i++)
		{
			bannerInnerHTML += '<dd><a href="';
			if (searchRange == 1) 
			{
				// 11Aデザイン変換スクリプトによって自動生成した処理(全角文字で検索できるよう対応)
				if (navigator.userAgent.indexOf("ricoh_mfpapnl") > -1) {
					bannerInnerHTML += "search_results.htm?seek=" + encodeURI(synonym[i]).replace(/#/g,'%23') + "&bookname=" + encodeURI(searchBookName).replace(/#/g,'%23') + "&fromSeachResultPage=1" + "&backto=" + encodeURI(backto).replace(/#/g,'%23') + getNewHash();
				} else {
					bannerInnerHTML += "search_results.htm?seek=" + escape(synonym[i]) + "&bookname=" + escape(searchBookName) + "&fromSeachResultPage=1" + "&backto=" + escape(backto) + getNewHash();
				}
			}
			else
			{
				// 11Aデザイン変換スクリプトによって自動生成した処理(全角文字で検索できるよう対応)
				if (navigator.userAgent.indexOf("ricoh_mfpapnl") > -1) {
					bannerInnerHTML += "search_results.htm?seek=" + encodeURI(synonym[i]).replace(/#/g,'%23') + "&bookname=" + encodeURI(searchBookName).replace(/#/g,'%23') + "&backto=" + encodeURI(backto).replace(/#/g,'%23') + getNewHash();
				} else {
					bannerInnerHTML += "search_results.htm?seek=" + escape(synonym[i]) + "&bookname=" + escape(searchBookName) + "&backto=" + escape(backto) + getNewHash();
				}
			}	
			
			//bannerInnerHTML += '" onclick=javascript:searchBooks();';
			bannerInnerHTML += '"';
			
			bannerInnerHTML += '>';
			bannerInnerHTML += escapeHTML(synonym[i]);
			bannerInnerHTML += '</a></dd>';
		}
		bannerInnerHTML += '</dl>';
	}
	//類義語の表示
	if (relatedWord.length > 0)
	{
		bannerInnerHTML += '<dl class="related"><dt>';
		bannerInnerHTML += escapeHTML('Wyszukaj w wynikach:');
		bannerInnerHTML += '</dt>';
		for (i = 0; i < relatedWord.length; i++)
		{
			bannerInnerHTML += '<dd><a href="';
			if (searchRange == 1) 
			{
				// 11Aデザイン変換スクリプトによって自動生成した処理(全角文字で検索できるよう対応)
				if (navigator.userAgent.indexOf("ricoh_mfpapnl") > -1) {
					bannerInnerHTML += "search_results.htm?seek=" + encodeURI(noRegSearchWord).replace(/#/g,'%23') + encodeURI(" ") + encodeURI(relatedWord[i]).replace(/#/g,'%23') + "&bookname=" + encodeURI(searchBookName).replace(/#/g,'%23') + "&fromSeachResultPage=1" + "&backto=" + encodeURI(backto).replace(/#/g,'%23') + getNewHash();
				} else {
					bannerInnerHTML += "search_results.htm?seek=" + escape(noRegSearchWord) + escape(" ") + escape(relatedWord[i]) + "&bookname=" + escape(searchBookName) + "&fromSeachResultPage=1" + "&backto=" + escape(backto) + getNewHash();
				}
			}
			else
			{
				// 11Aデザイン変換スクリプトによって自動生成した処理(全角文字で検索できるよう対応)
				if (navigator.userAgent.indexOf("ricoh_mfpapnl") > -1) {
					bannerInnerHTML += "search_results.htm?seek=" + encodeURI(noRegSearchWord).replace(/#/g,'%23') + encodeURI(" ") + encodeURI(relatedWord[i]).replace(/#/g,'%23') + "&bookname=" + searchBookName + "&backto=" + encodeURI(backto).replace(/#/g,'%23') + getNewHash();
				} else {
					bannerInnerHTML += "search_results.htm?seek=" + escape(noRegSearchWord) + escape(" ") + escape(relatedWord[i]) + "&bookname=" + searchBookName + "&backto=" + escape(backto) + getNewHash();
				}
			}
			
			//bannerInnerHTML += '" onclick=javascript:searchBooks();';
			bannerInnerHTML += '"';
			
			bannerInnerHTML += '>';
			bannerInnerHTML += escapeHTML(noRegSearchWord);
			bannerInnerHTML += ' ';
			bannerInnerHTML += escapeHTML(relatedWord[i]);
			bannerInnerHTML += '</a></dd>';
		}
		bannerInnerHTML += '</dl>';
	}
	document.getElementById("relatedAndSynonym").innerHTML = bannerInnerHTML;
}
/**
 * 検索結果画面で検索する時のURLを生成
 */
function send_message_search() {
	//マニュアル一覧がない場合、booknameは自分の分冊名にする。
	var bookname = "";
	if (document.getElementById("selectbook") != null)
	{
		bookname = document.getElementById("selectbook").value;
	} 
	else
	{
		bookname = get_key_from_url()["bookname"];
	}
	var word = document.getElementById("seek").value;
	var key = get_key_from_url();
	var backto = key["backto"];
	if ( backto == null || backto == "" || backto == undefined) {
		backto="";
	}
	// 11Aデザイン変換スクリプトによって自動生成した処理(全角文字で検索できるよう対応)
	if (navigator.userAgent.indexOf("ricoh_mfpapnl") > -1) {
		location.href = "search_results.htm?seek=" + encodeURI(word).replace(/#/g,'%23') + "&bookname=" + encodeURI(bookname).replace(/#/g,'%23') + "&fromSeachResultPage=1" + "&backto=" + encodeURI(backto).replace(/#/g,'%23') +getNewHash() ;
	} else {
		location.href = "search_results.htm?seek=" + escape(word) + "&bookname=" + escape(bookname) + "&fromSeachResultPage=1" + "&backto=" + escape(backto) + getNewHash() ;
	}
}

/**
 * ページングオブジェクトを定義する。
 */
function showPages(name,location)
{
	//初期化
	this.name = name; //ページングする対象の名称
	//今のページNoを求める
	this.page = 1; 
	this.pageCount = 1; //総ページ数
	this.showpage = 5; //一括で表示できるページ数
	this.id = "searchResult";// 結果表示領域のID
	this.searchResult = null;//検索結果
	this.summarys = null;//要約
}

/**
 * ページング表示：今のページ数と総ページ数の検査
 */ 
showPages.prototype.checkPages = function()
{
	//isNaN は、渡された引数を数に変換できるかどうかを試みます。
	//その引数が変換できなかった場合、true を返します。そうでない場合は、false を返します。
	if (isNaN(parseInt(this.page)))
	{
		this.page = 1;
	}
	if (isNaN(parseInt(this.pageCount)))
	{
		this.pageCount = 1;
	}
	if (this.page < 1)
	{
		this.page = 1;
	}
	if (this.pageCount < 1)
	{
		this.pageCount = 1;
	}
	if (this.page > this.pageCount)
	{
		this.page = this.pageCount;
	}
	this.page = parseInt(this.page);
	this.pagecount = parseInt(this.pageCount);
}

/**
 * ページング表示HTMLを生成する
 */ 
showPages.prototype.createHtml = function()
{
    //画面表示のHTML（innerHTML）を生成する
    var strHtml = '';
    if (this.searchResult != null) {
	var prevPage = this.page - 1;
	var nextPage = Number(this.page) + 1;
	if (prevPage < 1)
	{
	    strHtml += '<li class="prevoff"><img src = "../../web/gen/i_prev_g.gif" alt="' + escapeHTML('') + '">' + escapeHTML('Poprzednia strona') + '</li>';
	    strHtml += '<li class="sep"><img src = "../../web/gen/sep.gif" alt="' + escapeHTML('') + '"></li>';
	} 
	else 
	{
	    strHtml += '<li class="prevoff"><a href = "javascript:void(0);"' + ' title="Poprzednia strona"' + ' onclick="unFocus.History.addHistory(' + prevPage + '); return false;"><img src = "../../web/gen/i_prev.gif" alt="' + escapeHTML('') + '">' + escapeHTML('Poprzednia strona') + '</a></li>';
	    strHtml += '<li class="sep"><img src = "../../web/gen/sep.gif" alt="' + escapeHTML('') + '"></li>';
	}
	if (this.page < this.showpage)
	{
	    var startPage = this.page - this.page % Number(this.showpage) + 1;
	}
	else if (this.page == this.showpage && this.page == this.pageCount) 
	{
	    var startPage = 1;
	}
	else if (this.page >= this.showpage && this.pageCount > this.showpage )
	{
	    strHtml += '<li class="no"><a href = "javascript:void(0);"' + 'onclick="unFocus.History.addHistory(1); return false;">' + 1 + '</a></li><li class="econt">...</li>';
	    startPage = this.page - Math.ceil((this.showpage - 1) / 2);
	}
	if (this.page > this.showpage && this.pageCount < startPage + this.showpage - 1)
	{
	    var startPage = this.pageCount - this.showpage + 2;
	}
	for (var i = startPage; i < Number(startPage) + Number(this.showpage); i++)
	{
	    if (i > this.pageCount) break;
	    if (startPage > 1 && i == startPage + this.showpage - 1) break;
	    if (i == this.page)
	    {
		//検索結果が0件の場合、ページは表示しない。
		if (this.searchResult == null || this.searchResult.length == 0)
		{
		    strHtml += '<li class="this"></li>';
		}
		else
		{
		    strHtml += '<li class="this">' + i + '</li>';
		}
	    }
	    else
	    {
		strHtml += '<li class="no"><a href = "javascript:void(0);"' + 'onclick="unFocus.History.addHistory(' + i + '); return false;">' + i + '</a></li>';
	    }
	}
	if (this.pageCount != this.showpage && this.pageCount >= startPage + this.showpage - 1)
	{
	    strHtml += '<li class="econt">...</li>';
	}
	if (nextPage > this.pageCount)
	{
	    strHtml += '<li class="sep"><img src = "../../web/gen/sep.gif" alt="' + escapeHTML('') + '"></li>';
	    strHtml += '<li class="nextoff">' + escapeHTML('Następna strona') + '<img src = "../../web/gen/i_next_g.gif" alt="' + escapeHTML('') + '"></li>';
	}
	else
	{
	    strHtml += '<li class="sep"><img src = "../../web/gen/sep.gif" alt="' + escapeHTML('') + '"></li>';
	    strHtml += '<li class="nexton"><a href="javascript:void(0);"' + ' title="Następna strona"' + ' onclick="unFocus.History.addHistory(' + nextPage + '); return false;">' + escapeHTML('Następna strona') + '<img src = "../../web/gen/i_next.gif" alt="' + escapeHTML('') +  '"></a></li>';
	}
	strHtml += '</span><br />';
    }
    return strHtml;
}

/**
 * ページング：iページ目の内容を表示する
 */
function display(i)
{
	var startNo = 10 * (i - 1);
	var endNo = 10 * i;
	var resultHtml = '';
	// 検索ワード変数の取得
	var w = window.location.search.substring(0,5);
	if (paging.searchResult == null)
        {
		endNo = 0;
        }
        else if (endNo > paging.searchResult.length)
	{
		endNo = paging.searchResult.length;
	}
	for (i = startNo; i < endNo; i++)
	{
		var src = "../../" +  books[paging.searchResult[i].bookId].bookFolderName + "/int/" + pages[paging.searchResult[i].pageId].fileName;
		if (w == "?word")
		{
			src += "?&word=" + escape(get_key_from_url()["word"]);
		}
		if (w == "?seek")
		{
			// 11Aデザイン変換スクリプトによって自動生成した処理(全角文字で検索できるよう対応)
			if (navigator.userAgent.indexOf("ricoh_mfpapnl") > -1) {
				src += "?&seek=" + encodeURI(get_key_from_url()["seek"]).replace(/#/g,'%23');
			} else {
				src += "?&seek=" + escape(get_key_from_url()["seek"]);
			}
		}
		resultHtml += '<div class="fpage">';
		resultHtml += '<h2><a href = "';
		resultHtml += src;
		resultHtml += '">' + paging.searchResult[i].convertImgPageTitle("int") + '</a>';
		resultHtml += '</h2><ul><li class="book" id="bookname';
		resultHtml += i;
		resultHtml += '">';
		resultHtml += books[paging.searchResult[i].bookId].bookname;
		resultHtml += '</li><li class="summary">';
		if (paging.summarys[i].indexOf("<") > 0)
		{
			paging.summarys[i]=paging.summarys[i].replace(RegExp("<","g"),'&lt;');
		}
		if (paging.summarys[i].indexOf(">") > 0)
		{
			paging.summarys[i]=paging.summarys[i].replace(RegExp(">","g"),'&gt;');
		}
		resultHtml += paging.summarys[i];
		resultHtml += '</li></ul></div>';
	}
	return resultHtml;
}

/**
 * ページング：ページ遷移
 */
showPages.prototype.toPage = function(page)
{
	if (page <= 0) page = 1;	// for special case '#0', '#-1', '#-2' etc.
	this.page = page;
	document.getElementById("paging").innerHTML = this.createHtml();
	//検索結果を表示するHTML
	var resultHtml = '';
	//最初は1ページ目を表示する。
	resultHtml = display(page);
	document.getElementById("replace").innerHTML = resultHtml;
}

/**
 * ページングを生成する
 */
showPages.prototype.printHtml = function()
{
	this.checkPages();
	//最初は1ページ目を表示する。
	document.getElementById("replace").innerHTML = display(1);
	document.getElementById("paging").innerHTML = this.createHtml();
}

/**
 * 要約を取得する
 */
function getTextSummary(searchresult, searchWords, noRegSearchWords)
{
	//特殊記号の処理
	for (i = 0; i < noRegSearchWords.length; i++)
	{
		noRegSearchWords[i] = dealOtherLanguageMark(noRegSearchWords[i]);
	}
	
	var textSummary = new Array();
	for (j = 0; j < searchresult.length; j++)
	{
		var marks = new Array(' ', '.', ',', ':', ';', '?', '!');
		var regText = pages[searchresult[j].pageId].regText;
		var text = pages[searchresult[j].pageId].text;
		//firstの構成は {offset, key}
		var first = GetFirstOffSet(text, noRegSearchWords);	
		//本文が100文字未満
		if (text.length <= 100)
		{
			textSummary[j] = text;
		}
		//本文に検索ワードがない
		else if (!searchresult[j].textHitFlag || (typeof(first[1]) == "undefined"))
		{
			
			var location = getStringUntilMark(text, 99, 1);
			if (location > 0)
			{
				textSummary[j] = text.substring(0,location) + "...";
			}
			else
			{
				textSummary[j] = text;
			}
			
		}
		//一番目の検索キーワードが100以上の場合、キーワードのみ表示する。
		else if (noRegSearchWords[0].length >= 100)
		{
			if (first[0] > 0) 
			{
				textSummary[j] = "...";
				textSummary[j] += noRegSearchWords[0];
			}
			else{
				textSummary[j] =  noRegSearchWords[0];
			}
			
			if ((first[0] + first[1].length) < text.length)
			{
				textSummary[j] += "...";
			}
		}
		//検索ワードの前20文字が先頭50文字にかかる
		else if (first[0] <= 70)
		{
			
			var location = getStringUntilMark(text, 99, 1);
			if (location > 0)
			{
				textSummary[j] = text.substring(0,location) + "...";
			}
			else
			{
				textSummary[j] = text;
			}
			
		}
		//検索ワードの後20文字以内が末尾になる
		else if ((first[0]+ first[1].length + 20) > text.length)
		{
			
			var hasMarks = false;
			var objectString = text.substring(50, first[0]-20);
			for (var x = 0; x < marks.length; x++)
			{
				if (objectString.indexOf(marks[x]) != -1)
				{
					hasMarks = true;
					break;
				}
			}
			if (hasMarks == false)
			{
				textSummary[j] = text;
			}
			else
			{
				var location1 = getStringUntilMark(text.substring(0,first[0]-20-1), 49, 1);
				var location2 = getStringUntilMark(text.substring(0,first[0]-20-1), 49, 0);
				//"..."の中には1つの記号しかない。
				if (location1 == location2)
				{
					textSummary[j] = text;
				}
				else
				{
					textSummary[j] = text.substring(0,location1);
					textSummary[j] += "...";
					textSummary[j] += text.substring(location2);
				}
			}
			
		}
		//一般的な場合
		else
		{
			
			//1つ目の"..."の処理
			var hasMarks = false;
			var objectString = text.substring(50, first[0]-20);
			for (var x = 0; x < marks.length; x++)
			{
				if (objectString.indexOf(marks[x]) != -1)
				{
					hasMarks = true;
					break;
				}
			}
			if (hasMarks == false)
			{
				textSummary[j] = text.substring(0, first[0] + first[1].length + 20);
			}
			else
			{
				var location1 = getStringUntilMark(text.substring(0,first[0]-20-1), 49, 1);
				var location2 = getStringUntilMark(text.substring(0,first[0]-20-1), 49, 0);
				//1つ目の"..."の中には1つの記号しかない。
				if (location1 == location2)
				{
					textSummary[j] = text.substring(0, first[0] + first[1].length + 20);
				}
				else
				{
					textSummary[j] = text.substring(0,location1);
					textSummary[j] += "...";
					textSummary[j] += text.substring(location2, first[0] + first[1].length + 20);
				}
			}
			//2つ目の"..."の処理
			var location3 = getStringUntilMark(text, first[0] + first[1].length + 20, 1);
			if (location3 > 0)
			{
				textSummary[j] += text.substring(first[0] + first[1].length + 20, location3);
				textSummary[j] += "...";
			}
			
		}
	}
	return textSummary;
}
/**
 * 要約の表示：日本語、中国語、韓国語以外の場合。
 * 指定されているところは(' ', '.', ',', ':', ';', '?', '!')ではない場合は、これらが出るまで表示する。
 * この関数は上記記号が最初(或いは最後)に出てくる場所を探す。
 * textStringは本文文字列
 * offsetは指定されている場所
 * directionFlagは探す方向。1の場合は前から後へ。0の場合はその逆。
 */
function getStringUntilMark(textString, offset, directionFlag)
{
	var marks = new Array(' ', '.', ',', ':', ';', '?', '!');
	// 文字列の中で最初に出てきる記号の場所を探す
	var startOffsets = new Array();
	for (m = 0; m < marks.length; m++)
	{
		var markOffset = textString.substring(offset + 1).indexOf(marks[m]);
		if (markOffset != -1)
		{
			startOffsets[startOffsets.length] = markOffset;
		}
	}
	// 文字列の中で最後に出てきる記号の場所を探す
	var endOffsets = new Array();
	for (m = 0; m < marks.length; m++)
	{
		var markOffset = textString.substring(offset + 1).lastIndexOf(marks[m]);
		if (markOffset != -1)
		{
			endOffsets[endOffsets.length] = markOffset;
		}
	}

	if (directionFlag == 1)
	{
		var startOffset = startOffsets[0];
		for (m = 0; m < startOffsets.length; m++)
		{
			startOffset = Math.min(startOffsets[m], startOffset);
		}
		return (startOffset + offset + 2);
	}
	else
	{
		var endOffset = endOffsets[0];
		for (m = 0; m < endOffsets.length; m++)
		{
			endOffset = Math.max(endOffsets[m], endOffset);
		}
		return endOffset + offset + 2;
	}
}
/**
 * 最初にkeyが現れる位置とそのkeyを取得する
 * 戻り値：result = {offset, key}
 */
function GetFirstOffSet(text, searchWords)
{
	var offset = new Array();
	var result = new Array();
	//最初にkeyが現れる位置
	var firstOffset;
	//最初に現れるkey
	var firstKey;
	//検索キーワードのそれぞれが最初に現れる位置を取得する
	for (i = 0; i < searchWords.length; i++)
	{
		var reg = new RegExp(searchWords[i], "i");
		if (text.search(reg) != -1)
		{
			offset[offset.length] = text.search(reg);
		}
	}
	firstOffset = offset[0];
	for (i = 0; i < offset.length; i++)
	{
		firstOffset = Math.min(offset[i], firstOffset);
	}
	
	result[0] = firstOffset;
	//最初に現れるkeyを取得する
	for (i = 0; i < searchWords.length; i++)
	{
		var reg = new RegExp(searchWords[i], "i");
		if (text.search(reg) == firstOffset)
		{
			firstKey = searchWords[i];
		}
	}
	result[1] = firstKey;
	return result;
}

/**
 * 検索結果をソートする。
 * ソート順は下記のようになっております。
 * ?	検索ワードがタイトルに含まれるページ
 * ?	検索ワードの登場回数が多い順
 * ?	ページタイトルの文字コード順
 * ?	ページ番号（隠し機能）
 */
function sortResult(searchresult)
{
	// ソート順?でソートする
	// 検索ワードがタイトルに含まれている結果の配列
	var titleTagTrue = new Array();
	var t = 0;
	// 検索ワードがタイトルに含まれていない結果の配列
	var titleTagFalse = new Array();
	var f = 0;
	for (i = 0; i < searchresult.length; i++)
	{
		if (searchresult[i].titleHitFlag)
		{
			titleTagTrue[t] = searchresult[i];
			t++;
		}
		else
		{
			titleTagFalse[f] = searchresult[i];
			f++;
		}
	}
	
	//ソート順?、?、?でソートする
	titleTagTrue.sort(compareResult);
	titleTagFalse.sort(compareResult);
	return titleTagTrue.concat(titleTagFalse);
}

/**
 * ヒット回数で降順ソートの比較関数
 */
function compareResult(a, b)
{
	//ソート順?でソートする
	if (Number(b.hitTimes) - Number(a.hitTimes) != 0)
	{
    	return Number(b.hitTimes) - Number(a.hitTimes);
	}
	else
	{
		//ソート順?でソートする
		if (a.pageTitle != b.pageTitle)
		{
			return (a.pageTitle > b.pageTitle)?1:-1;
		}
		else
		{
			//ソート順?でソートする
			if (a.pageId != b.pageId)
			{
				return Number(a.hitTimes) - Number(b.hitTimes);
			}
			else
			{
				return 0;
			}
		}
	}
}

/**
 * 検索キーワードを取得する。
 * そして、AND検索か一語検索の判断もおこなう。
 * 索引画面のリンクからの検索は一語検索。その他はAND検索。
 */
function getKeyWords()
{
	var words = new Array();
	var result = new Array();
	
	// 検索ワード変数の取得
	var w = window.location.search.substring(0,5);
	
	//索引リンクの検索ワード変数は：word
	if (w == "?word")
	{
		words[0] = get_key_from_url()["word"];
	}
	else if (w == "?seek") 
	{
		var wordFromUrl = get_key_from_url()["seek"];
		//検索文字列の中にスペース(全角・半角)がある
		if (wordFromUrl != null && wordFromUrl != '' && typeof(wordFromUrl) != "undefined")
		{
			if (wordFromUrl.indexOf(" ") != -1 || wordFromUrl.indexOf("　") != -1)
			{
				var tempWords = wordFromUrl.split(" ");
				for (var s = 0; s < tempWords.length; s++)
				{
					if (tempWords[s].indexOf("　") != -1)
					{
						words = words.concat(tempWords[s].split("　"));
					}
					else
					{
						var tempWords2 = new Array(tempWords[s]);
						words = words.concat(tempWords2);
					}
				}
			}
			//検索文字列の中にスペースがない
			else
			{
				words[0] = wordFromUrl;
			}
		}
	}
	//検索キーワードリストから長さが0のキーワードを除去する。
	for (i = 0; i < words.length; i++)
	{
		if (words[i].length != 0)
		{
			result[result.length] = words[i];
		}
	}
	return result;
}

/**
 * JavaScriptの正規表現を使っている記号の処理
 */
function dealOtherLanguageMark(value)
{
	return escapeWord(value);	// defined in grep.js
}

/**
 * テキスト中のスペース（全角・半角）、タブを除去する。
 */
function removeSpace(value)
{
	if (value != null && value != '' && typeof(value) != "undefined") 
	{
		while (value.indexOf("\t") >= 0) 
		{
			value = value.replace("\t", "");
		}
		while (value.indexOf(" ") >= 0)
		{
			value = value.replace(" ", "");
		}
		while (value.indexOf("　") >= 0)
		{
			value = value.replace("　", "");
		}
	}
	return value;
}

function escapeHTML(str) {
	var div = document.createElement('div');
	var text = document.createTextNode(str);
	div.appendChild(text);
	return div.innerHTML;
}
