//分冊オブジェクトを定義する。
function Book(bookId, bookFolderName, bookname)
{
	this.bookId = bookId;
	this.bookFolderName = bookFolderName;
	this.bookname = bookname;
}

//ページオブジェクトを定義する。
function Page(bookId, pageTitle, regPageTitle, text, regText, fileName)
{
	this.bookId = bookId;
	this.pageTitle = pageTitle;
	this.regPageTitle = regPageTitle;
	this.text = text;
	this.regText = regText;
	this.fileName = fileName;
}

//検索結果オブジェクトを定義する。
function SearchResult(bookId, pageId, pageTitle, textHitFlag, titleHitFlag, hitTimes)
{
	this.bookId = bookId;
	this.pageId = pageId;
	this.pageTitle = pageTitle;
	this.textHitFlag = textHitFlag;
	this.titleHitFlag = titleHitFlag;
	this.hitTimes = hitTimes;

	//pageTitleにimgタグが含まれる場合、srcのパスを変換して返却する
	this.convertImgPageTitle = function(type) {
		var imgs = this.pageTitle.match(/<img\s.*?>/ig);
		if (imgs != null) {
			var ret = "";
			var other = this.pageTitle.split(/<img\s.*?>/i);
			for (var i = 0; i < imgs.length; i++) {
				imgs[i].match(/(.*src\s*=\s*")([^"]*)(.*)/i);
				var src = RegExp.$2;
				if (src.substring(0, 2) == "..")
					src = "../../" + books[this.bookId].bookFolderName + src.substring(2);
				else
					src = "../../" + books[this.bookId].bookFolderName + "/" + type + "/" + src;
				ret += other[i] + RegExp.$1 + src + RegExp.$3
			}
			ret += other[other.length - 1];
			return ret;
		}
		return this.pageTitle;
	}
}

//関連語オブジェクトを定義する。
function RelatedWord(key, book)
{
	this.book = book;
	this.key = key;
	this.words = new Array();
}

//類義語オブジェクトを定義する。
function Synonym(key, book)
{
	this.book = book;
	this.key = key;
	this.words = new Array();
}
